/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.factory;

import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapInfo;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapFacilityInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapOidInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoLocal;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectMonitorInfo {
    protected static Log m_log = LogFactory.getLog(SelectMonitorInfo.class);

    public MonitorSnmpTrapInfo getMonitorInfo(String monitorId) throws FinderException, NamingException, CreateException {
        MonitorSnmpTrapInfo monitorInfo = null;
        try {
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            SnmpTrapInfoLocal info = SnmpTrapInfoUtil.getLocalHome().findByPrimaryKey(new SnmpTrapInfoPK(monitorId));
            String facilityPath = repository.getFacilityPath(info.getFacilityId(), null);
            monitorInfo = new MonitorSnmpTrapInfo();
            monitorInfo.setMonitorId(info.getMonitorId());
            monitorInfo.setDescription(info.getDescription());
            monitorInfo.setFacilityId(info.getFacilityId());
            monitorInfo.setScope(facilityPath);
            monitorInfo.setCommunityName(info.getCommunityName());
            monitorInfo.setNotifyId(info.getNotifyId());
            monitorInfo.setApplication(info.getApplication());
            monitorInfo.setValid(info.getValidFlg());
            monitorInfo.setCalendarId(info.getCalendarId());
            monitorInfo.setRegDate(info.getRegDate());
            monitorInfo.setUpdateDate(info.getUpdateDate());
            monitorInfo.setRegUser(info.getRegUser());
            monitorInfo.setUpdateUser(info.getUpdateUser());
            Collection oids = info.getSnmpTrapOidInfo();
            ArrayList<MonitorSnmpTrapOidInfo> oidList = new ArrayList<MonitorSnmpTrapOidInfo>();
            for (SnmpTrapOidInfoLocal oid : oids) {
                MonitorSnmpTrapOidInfo oidInfo = new MonitorSnmpTrapOidInfo();
                oidInfo.setMonitorId(oid.getMonitorId());
                oidInfo.setMib(oid.getMib());
                oidInfo.setTrapOid(oid.getTrapOid());
                oidInfo.setGenericId(oid.getGenericId());
                oidInfo.setSpecificId(oid.getSpecificId());
                SnmpTrapMasterLocal master = SnmpTrapMasterUtil.getLocalHome().findByPrimaryKey(new SnmpTrapMasterPK(oid.getMib(), oid.getTrapOid(), oid.getGenericId(), oid.getSpecificId()));
                oidInfo.setTrapName(master.getUei());
                oidInfo.setValidFlg(oid.getValidFlg());
                oidInfo.setPriority(oid.getPriority());
                oidInfo.setLogmsg(oid.getLogmsg());
                oidInfo.setDescr(oid.getDescr());
                oidList.add(oidInfo);
            }
            monitorInfo.setOidInfos(oidList);
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = null;
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("getMonitorInfo():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = null;
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("getMonitorInfo():" + e.getMessage()));
            throw e;
        }
        return monitorInfo;
    }

    public ArrayList getMonitorList() throws CreateException, FinderException, NamingException {
        ArrayList list = null;
        try {
            Collection ct = SnmpTrapInfoUtil.getLocalHome().findAll();
            list = this.collectionToArray(ct);
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = null;
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("getMonitorList():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = null;
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("getMonitorList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = null;
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("getMonitorList():" + e.getMessage()));
            throw e;
        }
        return list;
    }

    public ArrayList collectionToArray(Collection ct) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        ArrayList list = new ArrayList();
        for (SnmpTrapInfoLocal monitor : ct) {
            Collection oids = monitor.getSnmpTrapOidInfo();
            String facilityPath = repository.getFacilityPath(monitor.getFacilityId(), null);
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(monitor.getMonitorId());
            info.add(monitor.getDescription());
            info.add(oids.size());
            info.add(facilityPath);
            info.add(monitor.getValidFlg());
            info.add(monitor.getRegUser());
            info.add(monitor.getRegDate() == null ? null : new Date(monitor.getRegDate().getTime()));
            info.add(monitor.getUpdateUser());
            info.add(monitor.getUpdateDate() == null ? null : new Date(monitor.getUpdateDate().getTime()));
            list.add(info);
        }
        return list;
    }

    public ArrayList<String> getMibList() throws FinderException, NamingException {
        ArrayList<String> mibList = null;
        try {
            Collection mibs = SnmpTrapMibMasterUtil.getLocalHome().findAll();
            mibList = new ArrayList<String>();
            for (SnmpTrapMibMasterLocal mib : mibs) {
                mibList.add(mib.getMib());
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = null;
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("getMibList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = null;
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("getMibList():" + e.getMessage()));
            throw e;
        }
        return mibList;
    }

    public ArrayList<SnmpTrapMasterInfo> getMasterList(String mib) throws FinderException, NamingException {
        ArrayList<SnmpTrapMasterInfo> masterList = null;
        try {
            Collection masters = null;
            masters = mib == null || mib.equals("") ? SnmpTrapMasterUtil.getLocalHome().findAll() : SnmpTrapMasterUtil.getLocalHome().findByMib(mib);
            masterList = new ArrayList<SnmpTrapMasterInfo>();
            for (SnmpTrapMasterLocal master : masters) {
                SnmpTrapMasterInfo info = new SnmpTrapMasterInfo();
                info.setMib(master.getMib());
                info.setTrapOid(master.getTrapOid());
                info.setGenericId(master.getGenericId());
                info.setSpecificId(master.getSpecificId());
                info.setUei(master.getUei());
                info.setPriority(master.getPriority());
                info.setLogmsg(master.getLogmsg());
                info.setDescr(master.getDescr());
                masterList.add(info);
            }
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = null;
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("getMasterList():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = null;
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("getMasterList():" + e.getMessage()));
            throw e;
        }
        return masterList;
    }

    public SnmpTrapMasterInfo getMasterInfo(SnmpTrapMasterPK pk) throws FinderException, NamingException {
        SnmpTrapMasterInfo info = null;
        try {
            SnmpTrapMasterLocal master = SnmpTrapMasterUtil.getLocalHome().findByPrimaryKey(pk);
            info = new SnmpTrapMasterInfo();
            info.setMib(master.getMib());
            info.setTrapOid(master.getTrapOid());
            info.setGenericId(master.getGenericId());
            info.setSpecificId(master.getSpecificId());
            info.setUei(master.getUei());
            info.setLogmsg(master.getLogmsg());
            info.setDescr(master.getDescr());
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = new String[]{pk.mib, pk.trapOid, Integer.toString(pk.genericId), Integer.toString(pk.specificId)};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("getMasterInfo():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("TRAP", "trap");
            Object[] args = new String[]{pk.mib, pk.trapOid, Integer.toString(pk.genericId), Integer.toString(pk.specificId)};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("getMasterInfo():" + e.getMessage()));
            throw e;
        }
        return info;
    }

    public SnmpTrapFacilityInfo getSnmpTrapFacilityInfo(String monitorId) throws CreateException, FinderException, NamingException {
        SnmpTrapFacilityInfo snmpTrapInfo = null;
        try {
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            SnmpTrapInfoLocal info = SnmpTrapInfoUtil.getLocalHome().findByPrimaryKey(new SnmpTrapInfoPK(monitorId));
            Collection oids = info.getSnmpTrapOidInfo();
            if (info.getValidFlg() == 1) {
                snmpTrapInfo = new SnmpTrapFacilityInfo();
                snmpTrapInfo.setMonitorId(monitorId);
                String facilityId = info.getFacilityId();
                snmpTrapInfo.setFacilityId(facilityId);
                ArrayList facilityIdList = null;
                if (repository.isNode(facilityId)) {
                    facilityIdList = new ArrayList();
                    facilityIdList.add(facilityId);
                } else {
                    facilityIdList = repository.getNodeFacilityIdList(facilityId, 0);
                }
                snmpTrapInfo.setFacilityIdList(facilityIdList);
                snmpTrapInfo.setCommunityName(info.getCommunityName());
                ArrayList<SnmpTrapOidInfo> oidList = new ArrayList<SnmpTrapOidInfo>();
                for (SnmpTrapOidInfoLocal oid : oids) {
                    if (oid.getValidFlg() != 1) continue;
                    SnmpTrapOidInfo oidInfo = new SnmpTrapOidInfo();
                    oidInfo.setTrapOid(oid.getTrapOid());
                    oidInfo.setGenericId(oid.getGenericId());
                    oidInfo.setSpecificId(oid.getSpecificId());
                    oidList.add(oidInfo);
                }
                snmpTrapInfo.setOidList(oidList);
            }
        }
        catch (CreateException e) {
            m_log.debug((Object)("getSnmpTrapFacilityInfo():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("getSnmpTrapFacilityInfo():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("getSnmpTrapFacilityInfo():" + e.getMessage()));
            throw e;
        }
        return snmpTrapInfo;
    }

    public HashMap<String, SnmpTrapFacilityInfo> getSnmpTrapFacilityMap() throws CreateException, FinderException, NamingException {
        HashMap<String, SnmpTrapFacilityInfo> map = new HashMap<String, SnmpTrapFacilityInfo>();
        try {
            RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
            Collection ct = SnmpTrapInfoUtil.getLocalHome().findAll();
            for (SnmpTrapInfoLocal info : ct) {
                Collection oids = info.getSnmpTrapOidInfo();
                SnmpTrapFacilityInfo snmpTrapInfo = new SnmpTrapFacilityInfo();
                if (info.getValidFlg() != 1) continue;
                String monitorId = info.getMonitorId();
                snmpTrapInfo.setMonitorId(monitorId);
                String facilityId = info.getFacilityId();
                snmpTrapInfo.setFacilityId(facilityId);
                ArrayList facilityIdList = null;
                if (repository.isNode(facilityId)) {
                    facilityIdList = new ArrayList();
                    facilityIdList.add(facilityId);
                } else {
                    facilityIdList = repository.getNodeFacilityIdList(facilityId, 0);
                }
                snmpTrapInfo.setFacilityIdList(facilityIdList);
                snmpTrapInfo.setCommunityName(info.getCommunityName());
                ArrayList<SnmpTrapOidInfo> oidList = new ArrayList<SnmpTrapOidInfo>();
                for (SnmpTrapOidInfoLocal oid : oids) {
                    if (oid.getValidFlg() != 1) continue;
                    SnmpTrapOidInfo oidInfo = new SnmpTrapOidInfo();
                    oidInfo.setTrapOid(oid.getTrapOid());
                    oidInfo.setGenericId(oid.getGenericId());
                    oidInfo.setSpecificId(oid.getSpecificId());
                    oidList.add(oidInfo);
                }
                snmpTrapInfo.setOidList(oidList);
                map.put(monitorId, snmpTrapInfo);
            }
        }
        catch (CreateException e) {
            m_log.debug((Object)("getSnmpTrapMap():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            m_log.debug((Object)("getSnmpTrapMap():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("getSnmpTrapMap():" + e.getMessage()));
            throw e;
        }
        return map;
    }
}

