/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.ejb.session;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.DetailTableDefine;
import com.clustercontrol.collectiverun.bean.HistoryTableDefine;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerLocal;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerUtil;
import com.clustercontrol.collectiverun.factory.DeleteMaster;
import com.clustercontrol.collectiverun.factory.HistoryFilterProperty;
import com.clustercontrol.collectiverun.factory.ModifyMaster;
import com.clustercontrol.collectiverun.factory.OperationRun;
import com.clustercontrol.collectiverun.factory.ParameterProperty;
import com.clustercontrol.collectiverun.factory.SelectMaster;
import com.clustercontrol.collectiverun.factory.SelectSession;
import com.clustercontrol.commons.ejb.UsedFacilityException;
import com.clustercontrol.commons.ejb.session.CheckFacility;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.util.QuartzUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

public abstract class CollectiveRunControllerBean
implements SessionBean,
CheckFacility {
    protected static Log m_log = LogFactory.getLog(CollectiveRunControllerBean.class);
    public static final String GROUP_NAME = "CRUN_MANAGEMENT";

    public ArrayList getHistoryTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(HistoryTableDefine.STATUS, new TableColumnInfo(Messages.getString((String)"run.status", (Locale)locale), 14, 80, 16384));
        tableDefine.add(HistoryTableDefine.SESSION_ID, new TableColumnInfo(Messages.getString((String)"session.id", (Locale)locale), -1, 140, 16384));
        tableDefine.add(HistoryTableDefine.START_TIME, new TableColumnInfo(Messages.getString((String)"start.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(HistoryTableDefine.END_TIME, new TableColumnInfo(Messages.getString((String)"end.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(HistoryTableDefine.TYPE, new TableColumnInfo(Messages.getString((String)"type", (Locale)locale), -1, 100, 16384));
        tableDefine.add(HistoryTableDefine.NAME, new TableColumnInfo(Messages.getString((String)"name", (Locale)locale), -1, 140, 16384));
        tableDefine.add(HistoryTableDefine.FACILITY_ID, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(HistoryTableDefine.SCOPE, new TableColumnInfo(Messages.getString((String)"scope", (Locale)locale), 2, 150, 16384));
        tableDefine.add(HistoryTableDefine.TOTAL, new TableColumnInfo(Messages.getString((String)"total", (Locale)locale), -1, 50, 16384));
        tableDefine.add(HistoryTableDefine.NORMAL, new TableColumnInfo(Messages.getString((String)"successful", (Locale)locale), -1, 50, 16384));
        tableDefine.add(HistoryTableDefine.WARNING, new TableColumnInfo(Messages.getString((String)"warning", (Locale)locale), -1, 50, 16384));
        tableDefine.add(HistoryTableDefine.ABNORMAL, new TableColumnInfo(Messages.getString((String)"failed", (Locale)locale), -1, 50, 16384));
        tableDefine.add(HistoryTableDefine.WAITING, new TableColumnInfo(Messages.getString((String)"waiting", (Locale)locale), -1, 50, 16384));
        tableDefine.add(HistoryTableDefine.RUNNING, new TableColumnInfo(Messages.getString((String)"running", (Locale)locale), -1, 50, 16384));
        return tableDefine;
    }

    public ArrayList getDetailTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(DetailTableDefine.STATUS, new TableColumnInfo(Messages.getString((String)"run.status", (Locale)locale), 14, 80, 16384));
        tableDefine.add(DetailTableDefine.END_STATUS, new TableColumnInfo(Messages.getString((String)"end.status", (Locale)locale), 11, 70, 16384));
        tableDefine.add(DetailTableDefine.RETURN_VALUE, new TableColumnInfo(Messages.getString((String)"return.value", (Locale)locale), -1, 50, 16384));
        tableDefine.add(DetailTableDefine.FACILITY_ID, new TableColumnInfo(Messages.getString((String)"facility.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(DetailTableDefine.FACILITY_NAME, new TableColumnInfo(Messages.getString((String)"facility.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(DetailTableDefine.START_TIME, new TableColumnInfo(Messages.getString((String)"start.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(DetailTableDefine.END_TIME, new TableColumnInfo(Messages.getString((String)"end.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(DetailTableDefine.MESSAGE, new TableColumnInfo(Messages.getString((String)"message", (Locale)locale), -1, 300, 16384));
        return tableDefine;
    }

    public Property getParameterPropertyBySessionId(String sessionId, Locale locale) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getPropertyBySessionId(sessionId, locale);
    }

    public Property getParameterProperty(String typeId, Locale locale) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getProperty(typeId, locale);
    }

    public String getParameterTypeId(String sessionId) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getTypeId(sessionId);
    }

    public Property getHistoryFilterProperty(Locale locale) throws FinderException, NamingException {
        Property historyFilterProperty = null;
        try {
            HistoryFilterProperty history = new HistoryFilterProperty();
            historyFilterProperty = history.getProperty(locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getHistoryFilterProperty() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return historyFilterProperty;
    }

    public ViewListInfo getHistoryList(Locale locale, int histories) throws FinderException, NamingException {
        ViewListInfo historyList = null;
        try {
            SelectSession select = new SelectSession();
            historyList = select.getHistoryList(locale, histories);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getHistoryList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return historyList;
    }

    public ViewListInfo getHistoryList(Property property, Locale locale, int histories) throws FinderException, NamingException {
        ViewListInfo historyList = null;
        try {
            SelectSession select = new SelectSession();
            historyList = select.getHistoryList(property, locale, histories);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getHistoryList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return historyList;
    }

    public ArrayList getDetailList(String sessionId, Locale locale) throws FinderException, NamingException {
        ArrayList detailList = null;
        try {
            SelectSession select = new SelectSession();
            detailList = select.getDetailList(sessionId, locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getDetailList() -> " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            throw e;
        }
        return detailList;
    }

    public void run(String typeId, Property property, Locale locale) throws Exception {
        String sessionId;
        CollectiveRunControllerLocal controller = CollectiveRunControllerUtil.getLocalHome().create();
        try {
            sessionId = controller.createSession(typeId, property, locale);
        }
        catch (Exception e) {
            AplLogger apllog = new AplLogger("CR", "cr");
            apllog.put("SYS", "002");
            throw e;
        }
        try {
            controller.run(sessionId);
        }
        catch (Exception e) {
            AplLogger apllog = new AplLogger("CR", "cr");
            apllog.put("SYS", "001");
            throw e;
        }
    }

    public String createSession(String typeId, Property property, Locale locale) throws CreateException, FinderException, NamingException {
        OperationRun operation = new OperationRun();
        return operation.createSession(typeId, property, locale);
    }

    public void run(String sessionId) throws CreateException, FinderException, NamingException, IOException {
        OperationRun operation = new OperationRun();
        operation.run(sessionId);
    }

    public void endNode(RunResultInfo info) throws FinderException, NamingException {
        OperationRun operation = new OperationRun();
        operation.endNode(info);
    }

    public void checkEndSession() throws FinderException, NamingException {
        OperationRun operation = new OperationRun();
        operation.checkEndSession();
    }

    public TreeItem getTree(Locale locale) throws FinderException, NamingException {
        SelectMaster select = new SelectMaster();
        return select.getTree(locale);
    }

    public void updateMaster(ItemInfo info, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException {
        ModifyMaster modify = new ModifyMaster();
        try {
            modify.update(info, parentInfo);
        }
        catch (NamingException e) {
            this.outputErrorUpdateMaster(info, parentInfo, e);
            throw e;
        }
        catch (CreateException e) {
            this.outputErrorUpdateMaster(info, parentInfo, (Exception)((Object)e));
            throw e;
        }
        catch (RemoveException e) {
            this.outputErrorUpdateMaster(info, parentInfo, (Exception)((Object)e));
            throw e;
        }
    }

    protected void outputErrorUpdateMaster(ItemInfo info, ItemInfo parentInfo, Exception e) {
        if (info == null || parentInfo == null) {
            return;
        }
        String id = "";
        String parentId = "";
        if (info.getType() == 0) {
            id = ((TypeInfo)info).getId();
        } else if (info.getType() == 1) {
            id = ((CommandInfo)info).getId();
            parentId = ((TypeInfo)parentInfo).getId();
        } else if (info.getType() == 2) {
            id = ((CommandParameterInfo)info).getId();
            parentId = ((CommandInfo)parentInfo).getId();
        } else if (info.getType() == 3) {
            id = ((ParameterInfo)info).getId();
        } else if (info.getType() == 4) {
            id = String.valueOf(((ParameterSelectInfo)info).getOrderNo());
            parentId = ((ParameterSelectInfo)info).getId();
        }
        AplLogger apllog = new AplLogger("CR", "cr");
        Object[] args = new String[]{String.valueOf(info.getType()), id, parentId};
        apllog.put("SYS", "007", args);
        m_log.debug((Object)("updateMaster() : " + e.getMessage()));
    }

    public void deleteMaster(ItemInfo info, ItemInfo parentInfo) throws EJBException, FinderException, NamingException, RemoveException {
        DeleteMaster delete = new DeleteMaster();
        try {
            delete.delete(info, parentInfo);
        }
        catch (EJBException e) {
            this.outputErrorDeleteMaster(info, parentInfo, (Exception)((Object)e));
            throw e;
        }
        catch (FinderException e) {
            this.outputErrorDeleteMaster(info, parentInfo, (Exception)((Object)e));
            throw e;
        }
        catch (NamingException e) {
            this.outputErrorDeleteMaster(info, parentInfo, e);
            throw e;
        }
        catch (RemoveException e) {
            this.outputErrorDeleteMaster(info, parentInfo, (Exception)((Object)e));
            throw e;
        }
    }

    protected void outputErrorDeleteMaster(ItemInfo info, ItemInfo parentInfo, Exception e) {
        if (info == null || parentInfo == null) {
            return;
        }
        String id = "";
        String parentId = "";
        if (info.getType() == 0) {
            id = ((TypeInfo)info).getId();
        } else if (info.getType() == 1) {
            id = ((CommandInfo)info).getId();
            parentId = ((TypeInfo)parentInfo).getId();
        } else if (info.getType() == 2) {
            id = ((CommandParameterInfo)info).getId();
            parentId = ((CommandInfo)parentInfo).getId();
        } else if (info.getType() == 3) {
            id = ((ParameterInfo)info).getId();
        } else if (info.getType() == 4) {
            id = String.valueOf(((ParameterSelectInfo)info).getOrderNo());
            parentId = ((ParameterSelectInfo)info).getId();
        }
        AplLogger apllog = new AplLogger("CR", "cr");
        Object[] args = new String[]{String.valueOf(info.getType()), id, parentId};
        apllog.put("SYS", "008", args);
        m_log.debug((Object)("deleteMaster() : " + e.getMessage()));
    }

    public void changeOrder(ItemInfo info1, ItemInfo info2, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException, FinderException {
        ModifyMaster modify = new ModifyMaster();
        modify.changeOrder(info1, info2, parentInfo);
    }

    public List getTypeStringList(Locale locale) throws FinderException, NamingException {
        List<String> typeStringList = null;
        try {
            typeStringList = SelectMaster.getTypeStringList(locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)("getTypeStringList() -> " + e.getMessage()));
        }
        catch (NamingException e) {
            throw e;
        }
        return typeStringList;
    }

    public HashMap getTypeHashMap(Locale locale) throws FinderException, NamingException {
        HashMap<String, String> typeHashMap = null;
        try {
            typeHashMap = SelectMaster.getTypeHashMap(locale);
        }
        catch (FinderException e) {
            m_log.debug((Object)e.getMessage());
        }
        catch (NamingException e) {
            throw e;
        }
        return typeHashMap;
    }

    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("CollectiveRunController", GROUP_NAME);
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("addQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        JobDetail job = new JobDetail("CollectiveRunController", GROUP_NAME, EJBInvokerJob.class);
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            job.getJobDataMap().put("java.naming.provider.url", "jnp://localhost:1100");
        }
        job.setDurability(true);
        job.setRequestsRecovery(true);
        job.getJobDataMap().put("ejb", "CollectiveRunController");
        job.getJobDataMap().put("method", "checkEndSession");
        Object[] jdArgs = new Object[]{};
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        CronTrigger cronTrigger = new CronTrigger("CollectiveRunController", GROUP_NAME);
        cronTrigger.setCronExpression(cronString);
        try {
            manager.addSchedule(job, (Trigger)cronTrigger);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule("CollectiveRunController", GROUP_NAME);
        }
        catch (SchedulerException e) {
            m_log.debug((Object)("deleteQuartz() : deleteJob error = " + e.getMessage()));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void isUseFacilityId(String facilityId) throws UsedFacilityException {
        try {
            Collection ct = null;
            ct = CRunSessionUtil.getLocalHome().findByFacilityId(facilityId);
            if (ct != null && ct.size() > 0) {
                for (CRunSessionLocal session : ct) {
                    if (session.getStatus() == 300) continue;
                    throw new UsedFacilityException(3);
                }
            }
            ct = null;
            ct = CRunSessionDetailUtil.getLocalHome().findByFacilityId(facilityId);
            if (ct != null && ct.size() > 0) {
                for (CRunSessionDetailLocal sessionDetail : ct) {
                    if (sessionDetail.getStatus() == 300) continue;
                    throw new UsedFacilityException(3);
                }
            }
        }
        catch (FinderException e) {
            m_log.debug((Object)("isUseFacilityId() : " + e.getMessage()));
        }
        catch (NamingException e) {
            m_log.debug((Object)("isUseFacilityId() : " + e.getMessage()));
        }
    }
}

