/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.factory;

import java.util.Locale;

import com.clustercontrol.accesscontrol.bean.RoleConstant;
import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.util.Messages;

/**
 * ユーザフィルタ用プロパティ作成クラスです。
 * 
 * ユーザをroleでフィルタする際に使用するクラスです。
 * 新機能の追加の際は、このクラスを修正して下さい。
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class UserFilterProperty extends RoleConstant{
	/** ユーザID */
	public static final String UID = "uid";
	/** 名前 */
	public static final String NAME = "namae";
	/** 説明 */
	public static final String DESCRIPTION = "description";
	
	/** アクセス権限 */
	public static final String ACCESS = "access";

	/**
	 * ユーザフィルタ用プロパティを返します。
	 * <p>
	 * <ol>
	 *  <li>フィルタ項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	 *      プロパティ（{@link com.clustercontrol.bean.Property}）を生成します。</li>
	 *  <li>各フィルタ項目のプロパティをツリー状に定義します。</li>
	 * </ol>
	 * 
	 * <p>プロパティに定義するフィルタ条件は、下記の通りです。
	 * <p>
	 * <ul>
	 *  <li>プロパティ（親。ダミー）</li>
	 *  <ul>
	 *   <li>ユーザID（子。テキスト）</li>
	 *   <li>名前（子。テキスト）</li>
	 *   <li>説明（子。テキスト）</li>
	 *   <li>アクセス権（子。テキスト）</li>
	 *   <ul>
	 *    <li>リポジトリ - 参照（孫。チェックボックス）</li>
	 *    <li>リポジトリ - 設定（孫。チェックボックス）</li>
	 *    <li>アクセス - 参照（孫。チェックボックス）</li>
	 *    <li>アクセス - 設定（孫。チェックボックス）</li>
	 *    <li>監視管理 - 参照（孫。チェックボックス）</li>
	 *    <li>監視管理 - 設定（孫。チェックボックス）</li>
	 *    <li>ジョブ管理 - 参照（孫。チェックボックス）</li>
	 *    <li>ジョブ管理 - 設定（孫。チェックボックス）</li>
	 *    <li>ジョブ管理 - 実行（孫。チェックボックス）</li>
	 *    <li>性能管理 - 参照（孫。チェックボックス）</li>
	 *    <li>性能管理 - 設定（孫。チェックボックス）</li>
	 *    <li>性能管理 - 実行（孫。チェックボックス）</li>
	 *    <li>一括制御 - 参照（孫。チェックボックス）</li>
	 *    <li>一括制御 - 設定（孫。チェックボックス）</li>
	 *    <li>一括制御 - 実行（孫。チェックボックス）</li>
	 *    <li>syslog-ng監視 - 参照（孫。チェックボックス）</li>
	 *    <li>syslog-ng監視 - 設定（孫。チェックボックス）</li>
	 *    <li>PING監視 - 参照（孫。チェックボックス）</li>
	 *    <li>PING監視 - 設定（孫。チェックボックス）</li>
	 *    <li>プロセス監視 - 参照（孫。チェックボックス）</li>
	 *    <li>プロセス監視 - 設定（孫。チェックボックス）</li>
	 *    <li>SNMP監視 - 参照（孫。チェックボックス）</li>
	 *    <li>SNMP監視 - 設定（孫。チェックボックス）</li>
	 *    <li>SNMPTRAP監視 - 参照（孫。チェックボックス）</li>
	 *    <li>SNMPTRAP監視 - 設定（孫。チェックボックス）</li>
	 *    <li>SQL監視 - 参照（孫。チェックボックス）</li>
	 *    <li>SQL監視 - 設定（孫。チェックボックス）</li>
	 *    <li>Hinemosエージェント監視 - 参照（孫。チェックボックス）</li>
	 *    <li>Hinemosエージェント監視 - 設定（孫。チェックボックス）</li>
	 *    <li>HTTP監視 - 参照（孫。チェックボックス）</li>
	 *    <li>HTTP監視 - 設定（孫。チェックボックス）</li>
	 *    <li>ログ転送 - 参照（孫。チェックボックス）</li>
	 *    <li>ログ転送 - 設定（孫。チェックボックス）</li>
	 *    <li>カレンダ - 参照（孫。チェックボックス）</li>
	 *    <li>カレンダ - 設定（孫。チェックボックス）</li>
	 *    <li>通知 - 参照（孫。チェックボックス）</li>
	 *    <li>通知 - 設定（孫。チェックボックス）</li>
	 *    <li>重要度判定 - 参照（孫。チェックボックス）</li>
	 *    <li>重要度判定 - 設定（孫。チェックボックス）</li>
	 *    <li>障害検知 - 参照（孫。チェックボックス）</li>
	 *    <li>障害検知 - 設定（孫。チェックボックス）</li>
	 *   </ul>
	 *  </ul>
	 * </ul>
	 * 
	 * @param locale ロケール情報
	 * @return ユーザフィルタ用プロパティ
	 * 
	 * @see com.clustercontrol.bean.Property
	 * @see com.clustercontrol.bean.PropertyConstant
	 */
	public Property getProperty(Locale locale) {
	    //UID
		Property uid =
			new Property(UID, Messages.getString("user.id", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//名前
		Property name =
			new Property(NAME, Messages.getString("name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//説明
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//アクセス権限
		Property access =
			new Property(ACCESS, Messages.getString("access.permission", locale), PropertyConstant.EDITOR_TEXT);
		//リポジトリ参照
		Property repositoryRead =
			new Property(REPOSITORY_READ, Messages.getString("repository.read", locale), PropertyConstant.EDITOR_BOOL);
		//リポジトリ設定
		Property repositoryWrite =
			new Property(REPOSITORY_WRITE, Messages.getString("repository.write", locale), PropertyConstant.EDITOR_BOOL);
		//アクセス参照
		Property accessRead =
			new Property(ACCESSCONTROL_READ, Messages.getString("accesscontrol.read", locale), PropertyConstant.EDITOR_BOOL);
		//アクセス設定
		Property accessWrite =
			new Property(ACCESSCONTROL_WRITE, Messages.getString("accesscontrol.write", locale), PropertyConstant.EDITOR_BOOL);
		//状態監視参照
		Property monitorRead =
			new Property(MONITOR_READ, Messages.getString("monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//状態監視設定
		Property monitorWrite =
			new Property(MONITOR_WRITE, Messages.getString("monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//ジョブ管理参照
		Property jobManagementRead =
			new Property(JOBMANAGEMENT_READ, Messages.getString("jobmanagement.read", locale), PropertyConstant.EDITOR_BOOL);
		//ジョブ設定
		Property jobManagementWrite =
			new Property(JOBMANAGEMENT_WRITE, Messages.getString("jobmanagement.write", locale), PropertyConstant.EDITOR_BOOL);
		//ジョブ実行
		Property jobManagementExecute =
			new Property(JOBMANAGEMENT_EXECUTE, Messages.getString("jobmanagement.execute", locale), PropertyConstant.EDITOR_BOOL);
		//性能管理参照
		Property performanceRead =
			new Property(PERFORMANCE_READ, Messages.getString("performance.read", locale), PropertyConstant.EDITOR_BOOL);
		//性能管理設定
		Property performanceWrite =
			new Property(PERFORMANCE_WRITE, Messages.getString("performance.write", locale), PropertyConstant.EDITOR_BOOL);
		//性能管理実行
		Property performanceExecute =
			new Property(PERFORMANCE_EXECUTE, Messages.getString("performance.execute", locale), PropertyConstant.EDITOR_BOOL);
		//一括制御参照
		Property collectiverunRead =
			new Property(COLLECTIVERUN_READ, Messages.getString("collectiverun.read", locale), PropertyConstant.EDITOR_BOOL);
		//一括制御設定
		Property collectiverunWrite =
			new Property(COLLECTIVERUN_WRITE, Messages.getString("collectiverun.write", locale), PropertyConstant.EDITOR_BOOL);
		//一括制御実行
		Property collectiverunExecute =
			new Property(COLLECTIVERUN_EXECUTE, Messages.getString("collectiverun.execute", locale), PropertyConstant.EDITOR_BOOL);
		//SyslogNG監視参照
		Property syslogngMonitorRead =
			new Property(SYSLOGNG_MONITOR_READ, Messages.getString("syslogng.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//SyslogNG監視設定
		Property syslogngMonitorWrite =
			new Property(SYSLOGNG_MONITOR_WRITE, Messages.getString("syslogng.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//Ping監視参照
		Property pingMonitorRead =
			new Property(PING_MONITOR_READ, Messages.getString("ping.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//Ping監視設定
		Property pingMonitorWrite =
			new Property(PING_MONITOR_WRITE, Messages.getString("ping.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//プロセス監視参照
		Property processMonitorRead =
			new Property(PROCESS_MONITOR_READ, Messages.getString("process.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//プロセス監視設定
		Property processMonitorWrite =
			new Property(PROCESS_MONITOR_WRITE, Messages.getString("process.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//SNMP監視参照
		Property snmpMonitorRead =
			new Property(SNMP_MONITOR_READ, Messages.getString("snmp.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//SNMP監視設定
		Property snmpMonitorWrite =
			new Property(SNMP_MONITOR_WRITE, Messages.getString("snmp.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//SNMPTRAP監視参照
		Property snmptrapMonitorRead =
			new Property(SNMPTRAP_MONITOR_READ, Messages.getString("snmptrap.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//SNMPTRAP監視設定
		Property snmptrapMonitorWrite =
			new Property(SNMPTRAP_MONITOR_WRITE, Messages.getString("snmptrap.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//SQL監視参照
		Property sqlMonitorRead =
			new Property(SQL_MONITOR_READ, Messages.getString("sql.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//SQL監視設定
		Property sqlMonitorWrite =
			new Property(SQL_MONITOR_WRITE, Messages.getString("sql.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//エージェント監視参照
		Property agentMonitorRead =
			new Property(AGENT_MONITOR_READ, Messages.getString("agent.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//エージェント監視設定
		Property agentMonitorWrite =
			new Property(AGENT_MONITOR_WRITE, Messages.getString("agent.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//HTTP監視参照
		Property httpMonitorRead =
			new Property(HTTP_MONITOR_READ, Messages.getString("http.monitor.read", locale), PropertyConstant.EDITOR_BOOL);
		//HTTP監視設定
		Property httpMonitorWrite =
			new Property(HTTP_MONITOR_WRITE, Messages.getString("http.monitor.write", locale), PropertyConstant.EDITOR_BOOL);
		//ログ転送参照
		Property logTransferRead =
			new Property(LOG_TRANSFER_READ, Messages.getString("logtransfer.read", locale), PropertyConstant.EDITOR_BOOL);
		//ログ転送設定
		Property logTransferWrite =
			new Property(LOG_TRANSFER_WRITE, Messages.getString("logtransfer.write", locale), PropertyConstant.EDITOR_BOOL);
		//カレンダ参照
		Property calendarRead =
			new Property(CALENDAR_READ, Messages.getString("calendar.read", locale), PropertyConstant.EDITOR_BOOL);
		//カレンダ設定
		Property calendarWrite =
			new Property(CALENDAR_WRITE, Messages.getString("calendar.write", locale), PropertyConstant.EDITOR_BOOL);
		//通知参照
		Property notifyRead =
			new Property(NOTIFY_READ, Messages.getString("notify.id.read", locale), PropertyConstant.EDITOR_BOOL);
		//通知設定
		Property notifyWrite =
			new Property(NOTIFY_WRITE, Messages.getString("notify.id.write", locale), PropertyConstant.EDITOR_BOOL);
		//重要度判定参照
		Property priorityJudgmentRead =
			new Property(PRIORITY_JUDGMENT_READ, Messages.getString("priority.judgment.read", locale), PropertyConstant.EDITOR_BOOL);
		//重要度判定設定
		Property priorityJudgmentWrite =
			new Property(PRIORITY_JUDGMENT_WRITE, Messages.getString("priority.judgment.write", locale), PropertyConstant.EDITOR_BOOL);
		//メンテナンス参照
		Property maintenanceRead =
			new Property(MAINTENANCE_READ, Messages.getString("maintenance.read", locale), PropertyConstant.EDITOR_BOOL);
		//メンテナンス設定
		Property maintenanceWrite =
			new Property(MAINTENANCE_WRITE, Messages.getString("maintenance.write", locale), PropertyConstant.EDITOR_BOOL);
		//障害検知参照
		Property troubleDetectionRead =
			new Property(TROUBLE_DETECTION_READ, Messages.getString("trouble.detection.read", locale), PropertyConstant.EDITOR_BOOL);
		//障害検知設定
		Property troubleDetectionWrite =
			new Property(TROUBLE_DETECTION_WRITE, Messages.getString("trouble.detection.write", locale), PropertyConstant.EDITOR_BOOL);
		
		
		//値を初期化
		uid.setValue("");
		name.setValue("");
		description.setValue("");
		
		access.setValue("");
		repositoryRead.setValue(Boolean.valueOf(false));
		repositoryWrite.setValue(Boolean.valueOf(false));
		accessRead.setValue(Boolean.valueOf(false));
		accessWrite.setValue(Boolean.valueOf(false));
		monitorRead.setValue(Boolean.valueOf(false));
		monitorWrite.setValue(Boolean.valueOf(false));
		jobManagementRead.setValue(Boolean.valueOf(false));
		jobManagementWrite.setValue(Boolean.valueOf(false));
		jobManagementExecute.setValue(Boolean.valueOf(false));
		performanceRead.setValue(Boolean.valueOf(false));
		performanceWrite.setValue(Boolean.valueOf(false));
		performanceExecute.setValue(Boolean.valueOf(false));
		collectiverunRead.setValue(Boolean.valueOf(false));
		collectiverunWrite.setValue(Boolean.valueOf(false));
		collectiverunExecute.setValue(Boolean.valueOf(false));
		syslogngMonitorRead.setValue(Boolean.valueOf(false));
		syslogngMonitorWrite.setValue(Boolean.valueOf(false));
		pingMonitorRead.setValue(Boolean.valueOf(false));
		pingMonitorWrite.setValue(Boolean.valueOf(false));
		processMonitorRead.setValue(Boolean.valueOf(false));
		processMonitorWrite.setValue(Boolean.valueOf(false));
		snmpMonitorRead.setValue(Boolean.valueOf(false));
		snmpMonitorWrite.setValue(Boolean.valueOf(false));
		snmptrapMonitorRead.setValue(Boolean.valueOf(false));
		snmptrapMonitorWrite.setValue(Boolean.valueOf(false));
		sqlMonitorRead.setValue(Boolean.valueOf(false));
		sqlMonitorWrite.setValue(Boolean.valueOf(false));
		agentMonitorRead.setValue(Boolean.valueOf(false));
		agentMonitorWrite.setValue(Boolean.valueOf(false));
		httpMonitorRead.setValue(Boolean.valueOf(false));
		httpMonitorWrite.setValue(Boolean.valueOf(false));
		logTransferRead.setValue(Boolean.valueOf(false));
		logTransferWrite.setValue(Boolean.valueOf(false));
		calendarRead.setValue(Boolean.valueOf(false));
		calendarWrite.setValue(Boolean.valueOf(false));
		notifyRead.setValue(Boolean.valueOf(false));
		notifyWrite.setValue(Boolean.valueOf(false));
		priorityJudgmentRead.setValue(Boolean.valueOf(false));
		priorityJudgmentWrite.setValue(Boolean.valueOf(false));
		maintenanceRead.setValue(Boolean.valueOf(false));
		maintenanceWrite.setValue(Boolean.valueOf(false));
		troubleDetectionRead.setValue(Boolean.valueOf(false));
		troubleDetectionWrite.setValue(Boolean.valueOf(false));
		
		//変更可及びコピー可を設定
		uid.setModify(PropertyConstant.MODIFY_OK);
		name.setModify(PropertyConstant.MODIFY_OK);
		description.setModify(PropertyConstant.MODIFY_OK);
		repositoryRead.setModify(PropertyConstant.MODIFY_OK);
		repositoryWrite.setModify(PropertyConstant.MODIFY_OK);
		accessRead.setModify(PropertyConstant.MODIFY_OK);
		accessWrite.setModify(PropertyConstant.MODIFY_OK);
		monitorRead.setModify(PropertyConstant.MODIFY_OK);
		monitorWrite.setModify(PropertyConstant.MODIFY_OK);
		jobManagementRead.setModify(PropertyConstant.MODIFY_OK);
		jobManagementWrite.setModify(PropertyConstant.MODIFY_OK);
		jobManagementExecute.setModify(PropertyConstant.MODIFY_OK);
		performanceRead.setModify(PropertyConstant.MODIFY_OK);
		performanceWrite.setModify(PropertyConstant.MODIFY_OK);
		performanceExecute.setModify(PropertyConstant.MODIFY_OK);
		collectiverunRead.setModify(PropertyConstant.MODIFY_OK);
		collectiverunWrite.setModify(PropertyConstant.MODIFY_OK);
		collectiverunExecute.setModify(PropertyConstant.MODIFY_OK);
		syslogngMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		syslogngMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		pingMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		pingMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		processMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		processMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		snmpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		snmpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		snmptrapMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		snmptrapMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		sqlMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		sqlMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		agentMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		agentMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		httpMonitorRead.setModify(PropertyConstant.MODIFY_OK);
		httpMonitorWrite.setModify(PropertyConstant.MODIFY_OK);
		logTransferRead.setModify(PropertyConstant.MODIFY_OK);
		logTransferWrite.setModify(PropertyConstant.MODIFY_OK);
		calendarRead.setModify(PropertyConstant.MODIFY_OK);
		calendarWrite.setModify(PropertyConstant.MODIFY_OK);
		notifyRead.setModify(PropertyConstant.MODIFY_OK);
		notifyWrite.setModify(PropertyConstant.MODIFY_OK);
		priorityJudgmentRead.setModify(PropertyConstant.MODIFY_OK);
		priorityJudgmentWrite.setModify(PropertyConstant.MODIFY_OK);
		maintenanceRead.setModify(PropertyConstant.MODIFY_OK);
		maintenanceWrite.setModify(PropertyConstant.MODIFY_OK);
		troubleDetectionRead.setModify(PropertyConstant.MODIFY_OK);
		troubleDetectionWrite.setModify(PropertyConstant.MODIFY_OK);
		
		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(uid);
		property.addChildren(name);
		property.addChildren(description);
		property.addChildren(access);
		
		// アクセス権限ツリー
		access.removeChildren();
		access.addChildren(repositoryRead);
		access.addChildren(repositoryWrite);
		access.addChildren(accessRead);
		access.addChildren(accessWrite);
		access.addChildren(monitorRead);
		access.addChildren(monitorWrite);
		access.addChildren(jobManagementRead);
		access.addChildren(jobManagementWrite);
		access.addChildren(jobManagementExecute);
		access.addChildren(performanceRead);
		access.addChildren(performanceWrite);
		access.addChildren(performanceExecute);
		access.addChildren(collectiverunRead);
		access.addChildren(collectiverunWrite);
		access.addChildren(collectiverunExecute);
		access.addChildren(syslogngMonitorRead);
		access.addChildren(syslogngMonitorWrite);
		access.addChildren(pingMonitorRead);
		access.addChildren(pingMonitorWrite);
		access.addChildren(processMonitorRead);
		access.addChildren(processMonitorWrite);
		access.addChildren(snmpMonitorRead);
		access.addChildren(snmpMonitorWrite);
		access.addChildren(snmptrapMonitorRead);
		access.addChildren(snmptrapMonitorWrite);
		access.addChildren(sqlMonitorRead);
		access.addChildren(sqlMonitorWrite);
		access.addChildren(agentMonitorRead);
		access.addChildren(agentMonitorWrite);
		access.addChildren(httpMonitorRead);
		access.addChildren(httpMonitorWrite);
		access.addChildren(logTransferRead);
		access.addChildren(logTransferWrite);
		access.addChildren(calendarRead);
		access.addChildren(calendarWrite);
		access.addChildren(notifyRead);
		access.addChildren(notifyWrite);
		access.addChildren(priorityJudgmentRead);
		access.addChildren(priorityJudgmentWrite);
		access.addChildren(maintenanceRead);
		access.addChildren(maintenanceWrite);
		
		String serverName = System.getProperty("jboss.server.name");
		if(serverName.equals("all")){
			access.addChildren(troubleDetectionRead);
			access.addChildren(troubleDetectionWrite);
		}
		
		return property;
	}
}
