

-- 
-- TABLE: cc_cal_info 
--

CREATE TABLE cc_cal_info(
    calendar_id       VARCHAR(64)       NOT NULL,
    calendar_name     VARCHAR(256)      NOT NULL,
    description       VARCHAR(256),
    start_time        TIME,
    valid_time_from   TIMESTAMP         NOT NULL,
    valid_time_to     TIMESTAMP         NOT NULL,
    reg_date          TIMESTAMP,
    update_date       TIMESTAMP,
    reg_user          VARCHAR(64),
    update_user       VARCHAR(64),
    CONSTRAINT p_key_cc_cal_info PRIMARY KEY (calendar_id)
) 
;


-- 
-- TABLE: cc_cal_weekday_info 
--

CREATE TABLE cc_cal_weekday_info(
    calendar_id       VARCHAR(64)       NOT NULL,
    weekday           SMALLINT          NOT NULL,
    time_from         TIME              NOT NULL,
    time_to           TIME              NOT NULL,
    description       VARCHAR(256),
    reg_date          TIMESTAMP,
    update_date       TIMESTAMP,
    reg_user          VARCHAR(64),
    update_user       VARCHAR(64),
    CONSTRAINT p_key_cc_cal_weekday_info PRIMARY KEY (calendar_id, weekday, time_from, time_to)
) 
;


-- 
-- TABLE: cc_cal_add_info 
--

CREATE TABLE cc_cal_add_info(
    calendar_id       VARCHAR(64)       NOT NULL,
    time_from         TIMESTAMP         NOT NULL,
    time_to           TIMESTAMP         NOT NULL,
    execute_flg       SMALLINT          NOT NULL,
    description       VARCHAR(256),
    reg_date          TIMESTAMP,
    update_date       TIMESTAMP,
    reg_user          VARCHAR(64),
    update_user       VARCHAR(64),
    CONSTRAINT p_key_cc_cal_add_info PRIMARY KEY (calendar_id, time_from, time_to)
) 
;


-- 
-- TABLE: cc_cal_weekday_info 
--

ALTER TABLE cc_cal_weekday_info ADD CONSTRAINT Refcc_cal_info1
    FOREIGN KEY (calendar_id)
    REFERENCES cc_cal_info(calendar_id)
;


-- 
-- TABLE: cc_cal_add_info 
--

ALTER TABLE cc_cal_add_info ADD CONSTRAINT Refcc_cal_info2
    FOREIGN KEY (calendar_id)
    REFERENCES cc_cal_info(calendar_id)
;

