/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.io.Serializable;

/**
 * スコープ情報を保持するクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityInfo implements Serializable {

    // ----- instance フィールド ----- //

    /** ファシリティID */
    private String facilityId = null;

    /** ファシリティ名 */
    private String facilityName = null;

    /** 種別 */
    private int type = 0;

    // ----- コンストラクタ ----- //

    /**
     * 初期化されたインスタンスを返します。
     */
    public FacilityInfo() {
        this.initialize();
    }

    // ----- instance メソッド ----- /

    /**
     * オブジェクトを初期化します。
     */
    public void initialize() {
        this.setFacilityId("");
        this.setFacilityName("");
        this.setType(FacilityConstant.TYPE_NODE);
    }

    /**
     * ファシリティIDを返します。
     * 
     * @return ファシリティID
     */
    public String getFacilityId() {
        return this.facilityId;
    }

    /**
     * ファシリティIDを設定します。
     * 
     * @param facilityId
     *            ファシリティID
     */
    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    /**
     * ファシリティ名を返します。
     * 
     * @return ファシリティ名
     */
    public String getFacilityName() {
        return this.facilityName;
    }

    /**
     * ファシリティ名を設定します。
     * 
     * @param name
     *            ファシリティ名
     */
    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    /**
     * 種別を返します。
     * 
     * @return type 種別
     */
    public int getType() {
        return this.type;
    }

    /**
     * 種別を設定します。
     * 
     * @param type
     *            種別
     */
    public void setType(int type) {
        this.type = type;
    }
}