/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * カレンダ追加情報変更クラス
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class ModifyAddInfoProperty {

    /**
     * 指定したカレンダ追加情報について、属性の変更を行います。
     * 
     * @param property 属性情報
     * @return 変更に成功した場合、true
     */
    public boolean edit(String id, Date from, Date to, Property property) {
    	Property copy = PropertyUtil.copy(property);
        PropertyUtil.deletePropertyDefine(copy);
        
        CalendarController calendar = 
			EjbConnectionManager.getConnectionManager().getCalendarController();
		
		boolean result = false;
        try {
        	calendar.modifyAddInfo(id, from, to, copy);
        	result = true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NamingException e) {
        } catch (FinderException e) {
        } catch (RemoveException e) {
		} catch (CreateException e) {
			if(e instanceof DuplicateKeyException){
				// 実行例外が重複している場合、エラーダイアログを表示する
	            MessageDialog.openInformation(
	            		null, 
	            		Messages.getString("message"),
	                    Messages.getString("message.calendar.29"));
	            return result;
			}
		}
		
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.calendar.17"));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.calendar.18"));
		}
    	
    	return result;
    }
}