/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.io.Serializable;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefine;

/**
 * スコープツリープロパティ定義
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopePropertyDefine extends PropertyDefine implements Serializable {
	private static final long serialVersionUID = -55095307970824890L;

	/**
     * コンストラクタ
     */
    public ScopePropertyDefine() {
        m_cellEditor = new ScopeDialogCellEditor();
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getColumnText(java.lang.Object)
     */
    public String getColumnText(Object value) {
        //プロパティ値がファシリティツリーならば、スコープパスを表示
        if (value instanceof FacilityTreeItem) {
            FacilityPath path = new FacilityPath(ClusterControlPlugin
                    .getDefault().getSeparator());
            return path.getPath((FacilityTreeItem) value);
        } else if (value instanceof String) {
            // 文字列の場合は、そのまま表示する。
            return (String) value;
        } else {
            return "";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getValue(com.clustercontrol.bean.Property)
     */
    public Object getValue(Property element) {
        //プロパティ値がファシリティツリーならば、スコープパスを表示
        Object value = element.getValue();
        if (value instanceof FacilityTreeItem) {
            FacilityPath path = new FacilityPath(ClusterControlPlugin
                    .getDefault().getSeparator());
            return path.getPath((FacilityTreeItem) value);
        } else if (value instanceof String) {
            // 文字列の場合は、そのまま表示する。
            return (String) value;
        } else {
            return "";
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#modify(com.clustercontrol.bean.Property,
     *      java.lang.Object)
     */
    public void modify(Property element, Object value) {
        //変更値がファシリティツリーならば、プロパティ値に設定する
        if (value instanceof FacilityTreeItem) {
            element.setValue(value);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#initEditer()
     */
    public void initEditer() {

    }
}