/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.logtransfer.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ログ転送情報を登録するクラスです。
 * 
 * @version 2.2.0
 * @since 2.1.0
 */
public class AddLogTransfer {
	
	/**
	 * ログ転送情報を追加します。
	 * 
	 * @param info ログ転送情報
	 * @return 登録に成功した場合、true
	 */
	public boolean add(LogTransferInfo info) {
		
		LogTransferController logTransfer = EjbConnectionManager.getConnectionManager().getLogTransferController();
		
		boolean result = false;
		String[] args = { info.getTransferId() };
		try {
			result = logTransfer.addLogTransfer(info);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
			if(e instanceof DuplicateKeyException){
				// 転送設定IDが重複している場合、エラーダイアログを表示する
	            MessageDialog.openInformation(
	            		null, 
	            		Messages.getString("message"),
	                    Messages.getString("message.logtransfer.18", args));
	            return result;
			}
		} catch (NamingException e) {
		} catch (JMSException e) {
		}
		
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.logtransfer.1", args));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.logtransfer.2", args));
		}
    	
    	return result;
	}
}