/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.logtransfer.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ログ転送一覧テーブル定義情報を取得するクラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetLogTransferListTableDefine {
	
	/**
	 * ログ転送一覧のテーブル定義情報を返します。
	 * 
	 * @return ログ転送一覧テーブル定義情報
	 */
	public static ArrayList get() {
		LogTransferController logTransfer = EjbConnectionManager.getConnectionManager()
		.getLogTransferController();
		
		ArrayList tableDefine = null;
		try {
			tableDefine = logTransfer.getLogTransferListTableDefine(Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		}
		return tableDefine;
	}
}