/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

import java.sql.Timestamp;
import java.util.ArrayList;

import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.StatusExpirationConstant;
import com.clustercontrol.bean.StatusValidPeriodConstant;
import com.clustercontrol.bean.ValidConstant;

/**
 * 通知情報を保持するクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyInfo
implements java.io.Serializable
{
	private static final long serialVersionUID = -4587823656729541121L;
	
	/** 通知ID。 */
	private java.lang.String m_notifyId;
	
	/** 説明。 */
	private java.lang.String m_description;
	
	/**
	 * イベント通知フラグ。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private java.lang.Integer m_eventFlg = new Integer(ValidConstant.TYPE_INVALID);
	
	/**
	 * 抑制間隔フラグ。
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	private java.lang.Integer m_inhibitionFlg = new Integer(ExclusionConstant.TYPE_NO);
	
	/** 抑制回数。 */
	private java.lang.Integer m_inhibitionFrequency;
	
	/** 抑制期間（分）。 */
	private java.lang.Integer m_inhibitionPeriod;
	
	/** 作成日時。 */
	private java.sql.Timestamp m_regDate;
	
	/**
	 * ステータス通知フラグ。
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	private java.lang.Integer m_statusFlg = new Integer(ValidConstant.TYPE_INVALID);
	
	/**
	 * 存続期間経過後の処理フラグ。
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	private java.lang.Integer m_statusInvalidFlg = new Integer(StatusExpirationConstant.TYPE_UPDATE);
	
	/**
	 * ステータス情報更新時重要度。
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	private java.lang.Integer m_statusUpdatePriority = new Integer(PriorityConstant.TYPE_WARNING);
	
	/**
	 * ステータス情報の存続期間。
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	private java.lang.Integer m_statusValidPeriod = new Integer(StatusValidPeriodConstant.TYPE_MIN_10);
	
	/** 最終変更日時。 */
	private java.sql.Timestamp m_updateDate;
	
	/** 通知イベント情報。 */
	private java.util.ArrayList<NotifyEventInfo> m_notifyEventInfo;
	
	/**
	 * コンストラクタ。
	 */
	public NotifyInfo() {
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param notifyId 通知ID
	 * @param description 説明
	 * @param eventFlg イベント通知フラグ
	 * @param inhibitionFlg 抑制間隔フラグ
	 * @param inhibitionFrequency 抑制回数
	 * @param inhibitionPeriod 抑制期間（分）
	 * @param regDate 作成日時
	 * @param statusFlg ステータス通知フラグ
	 * @param statusInvalidFlg 存続期間経過後の処理フラグ
	 * @param statusUpdatePriority ステータス情報更新時重要度
	 * @param statusValidPeriod ステータス情報の存続期間
	 * @param updateDate 最終変更日時
	 * @param notifyEventInfo 通知イベント情報
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.ExclusionConstant
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public NotifyInfo(
			String notifyId,
			String description,
			Integer eventFlg,
			Integer inhibitionFlg,
			Integer inhibitionFrequency,
			Integer inhibitionPeriod,
			Timestamp regDate,
			Integer statusFlg,
			Integer statusInvalidFlg,
			Integer statusUpdatePriority,
			Integer statusValidPeriod,
			Timestamp updateDate,
			ArrayList<NotifyEventInfo> notifyEventInfo ) {
		
		setNotifyId(notifyId);
		setDescription(description);
		setEventFlg(eventFlg);
		setInhibitionFlg(inhibitionFlg);
		setInhibitionFrequency(inhibitionFrequency);
		setInhibitionPeriod(inhibitionPeriod);
		setRegDate(regDate);
		setStatusFlg(statusFlg);
		setStatusInvalidFlg(statusInvalidFlg);
		setStatusUpdatePriority(statusUpdatePriority);
		setStatusValidPeriod(statusValidPeriod);
		setUpdateDate(updateDate);
		setNotifyEventInfo(notifyEventInfo);
	}
	
	/**
	 * コンストラクタ。
	 * 
	 * @param otherData コピー元の通知情報
	 */
	public NotifyInfo( NotifyInfo otherData ) {
		
		setNotifyId(otherData.getNotifyId());
		setDescription(otherData.getDescription());
		setEventFlg(otherData.getEventFlg());
		setInhibitionFlg(otherData.getInhibitionFlg());
		setInhibitionFrequency(otherData.getInhibitionFrequency());
		setInhibitionPeriod(otherData.getInhibitionPeriod());
		setRegDate(otherData.getRegDate());
		setStatusFlg(otherData.getStatusFlg());
		setStatusInvalidFlg(otherData.getStatusInvalidFlg());
		setStatusUpdatePriority(otherData.getStatusUpdatePriority());
		setStatusValidPeriod(otherData.getStatusValidPeriod());
		setUpdateDate(otherData.getUpdateDate());
		setNotifyEventInfo(otherData.getNotifyEventInfo());
		
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @return 通知ID
	 */
	public String getNotifyId() {
		return this.m_notifyId;
	}
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @param notifyId 通知ID
	 */
	public void setNotifyId( String notifyId ) {
		this.m_notifyId = notifyId;
	}
	
	/**
	 * 説明を返します。
	 * 
	 * @return 説明
	 */
	public String getDescription() {
		return this.m_description;
	}
	
	/**
	 * 説明を設定します。
	 * 
	 * @param description 説明
	 */
	public void setDescription( String description ) {
		this.m_description = description;
	}
	
	/**
	 * イベント通知フラグを返します。
	 * 
	 * @return イベント通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public Integer getEventFlg() {
		return this.m_eventFlg;
	}
	
	/**
	 * イベント通知フラグを設定します。
	 * 
	 * @param eventFlg イベント通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public void setEventFlg( Integer eventFlg ) {
		this.m_eventFlg = eventFlg;
	}
	
	/**
	 * 抑制間隔フラグを返します。
	 * 
	 * @return 抑制間隔フラグ
	 * 
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public Integer getInhibitionFlg() {
		return this.m_inhibitionFlg;
	}
	
	/**
	 * 抑制間隔フラグを設定します。
	 * 
	 * @param inhibitionFlg 抑制間隔フラグ
	 * 
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public void setInhibitionFlg( Integer inhibitionFlg ) {
		this.m_inhibitionFlg = inhibitionFlg;
	}
	
	/**
	 * 抑制回数を返します。
	 * 
	 * @return 抑制回数
	 */
	public Integer getInhibitionFrequency() {
		return this.m_inhibitionFrequency;
	}
	
	/**
	 * 抑制回数を設定します。
	 * 
	 * @param inhibitionFrequency 抑制回数
	 */
	public void setInhibitionFrequency( Integer inhibitionFrequency ) {
		this.m_inhibitionFrequency = inhibitionFrequency;
	}
	
	/**
	 * 抑制期間を返します。
	 * 
	 * @return inhibitionPeriod 抑制期間（分）
	 */
	public Integer getInhibitionPeriod() {
		return this.m_inhibitionPeriod;
	}
	
	/**
	 * 抑制期間を設定します。
	 * 
	 * @param inhibitionPeriod 抑制期間（分）
	 */
	public void setInhibitionPeriod( Integer inhibitionPeriod ) {
		this.m_inhibitionPeriod = inhibitionPeriod;
	}
	
	/**
	 * 作成日時を返します。
	 * 
	 * @return 作成日時
	 */
	public java.sql.Timestamp getRegDate() {
		return this.m_regDate;
	}
	
	/**
	 * 作成日時を設定します。
	 * 
	 * @param regDate 作成日時
	 */
	public void setRegDate( java.sql.Timestamp regDate ) {
		this.m_regDate = regDate;
	}
	
	/**
	 * ステータス通知フラグを返します。
	 * 
	 * @return ステータス通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public Integer getStatusFlg() {
		return this.m_statusFlg;
	}
	
	/**
	 * ステータス通知フラグを設定します。
	 * 
	 * @param statusFlg ステータス通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public void setStatusFlg( Integer statusFlg ) {
		this.m_statusFlg = statusFlg;
	}
	
	/**
	 * 存続期間経過後の処理フラグを返します。
	 * 
	 * @return 存続期間経過後の処理フラグ
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public Integer getStatusInvalidFlg() {
		return this.m_statusInvalidFlg;
	}
	
	/**
	 * 存続期間経過後の処理フラグを設定します。
	 * 
	 * @param statusInvalidFlg 存続期間経過後の処理フラグ
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public void setStatusInvalidFlg( Integer statusInvalidFlg ) {
		this.m_statusInvalidFlg = statusInvalidFlg;
	}
	
	/**
	 * ステータス情報更新時重要度を返します。
	 * 
	 * @return ステータス情報更新時重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public Integer getStatusUpdatePriority() {
		return this.m_statusUpdatePriority;
	}
	
	/**
	 * ステータス情報更新時重要度を設定します。
	 * 
	 * @param statusUpdatePriority ステータス情報更新時重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setStatusUpdatePriority( Integer statusUpdatePriority ) {
		this.m_statusUpdatePriority = statusUpdatePriority;
	}
	
	/**
	 * ステータス情報の存続期間を返します。
	 * 
	 * @return ステータス情報の存続期間
	 * 
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public Integer getStatusValidPeriod() {
		return this.m_statusValidPeriod;
	}
	
	/**
	 * ステータス情報の存続期間を設定します。
	 * 
	 * @param statusValidPeriod ステータス情報の存続期間
	 * 
	 * @see com.clustercontrol.bean.StatusValidPeriodConstant
	 */
	public void setStatusValidPeriod( Integer statusValidPeriod ) {
		this.m_statusValidPeriod = statusValidPeriod;
	}
	
	/**
	 * 最終変更日時を返します。
	 * 
	 * @return 最終変更日時
	 */
	public java.sql.Timestamp getUpdateDate() {
		return this.m_updateDate;
	}
	
	/**
	 * 最終変更日時を設定します。
	 * 
	 * @param updateDate 最終変更日時
	 */
	public void setUpdateDate( java.sql.Timestamp updateDate ) {
		this.m_updateDate = updateDate;
	}
	
	/**
	 * 通知イベント情報を返します。
	 * 
	 * @return 通知イベント情報
	 * 
	 * @see com.clustercontrol.notify.bean.NotifyEventInfo
	 */
	public java.util.ArrayList<NotifyEventInfo> getNotifyEventInfo() {
		return this.m_notifyEventInfo;
		
	}
	
	/**
	 * 通知イベント情報を設定します。
	 * 
	 * @param notifyEventInfo 通知イベント情報
	 * 
	 * @see com.clustercontrol.notify.bean.NotifyEventInfo
	 */
	public void setNotifyEventInfo(java.util.ArrayList<NotifyEventInfo> notifyEventInfo) {
		this.m_notifyEventInfo = notifyEventInfo;
	}
}
