/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.util.Messages;


/**
 * アプリケーション付き通知ID一覧コンポジットクラスです。
 * <p>
 * <dl>
 *  <dt>コンポジット</dt>
 *  <dd>「通知ID」 ラベル（親）</dd>
 *  <dd>「通知ID一覧」 コンボボックス（親）</dd>
 *  <dd>「参照」 ボタン（親）</dd>
 *  <dd>「アプリケーション」 テキストボックス</dd>
 * </dl>
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class NotifyInfoComposite extends NotifyIdListComposite {

    /** アプリケーション ラベル。 */
    private Label labelApplication = null;
    
    /** アプリケーション ラベル文字列。 */
    private Text textApplication = null;

    
	/**
     * インスタンスを返します。
	 * <p>
	 * 初期処理を呼び出し、コンポジットを配置します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * 
     * @see org.eclipse.swt.SWT
	 * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
	 * @see #initialize(Composite)
     */
    public NotifyInfoComposite(Composite parent, int style) {
    	super(parent, style, true);

        this.initialize(parent);
    }
    
    /**
     * インスタンスを返します。
     * <p>
	 * 初期処理を呼び出し、コンポジットを配置します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * @param text アプリケーション ラベル文字列
     * 
     * @see org.eclipse.swt.SWT
	 * @see org.eclipse.swt.widgets.Composite#Composite(Composite parent, int style)
	 * @see #initialize(Composite)
     */
    public NotifyInfoComposite(Composite parent, int style, String text) {
    	super(parent, style, text);

        this.initialize(parent);
    }

    /**
	 * コンポジットを配置します。
	 */
    private void initialize(Composite parent) {
    	
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 15;
        this.setLayout(layout);
        
        /*
         * アプリケーションID
         */
        // ラベル
        this.labelApplication = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.labelApplication.setLayoutData(gridData);
        this.labelApplication.setText(Messages.getString("application") + " : ");
        // テキスト
        this.textApplication = new Text(this, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.textApplication.addVerifyListener(new StringVerifyListener(DataRangeConstant.VARCHAR_64));
        this.textApplication.setLayoutData(gridData);
    }

	
	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		this.textApplication.setEnabled(enabled);
	}
	
	/**
	 * アプリケーションを返します。
	 * 
	 * @return アプリケーション
	 */
	public String getApplication() {
		
		return this.textApplication.getText();
	}

	/**
	 * アプリケーションを設定します。
	 */
	public void setApplication(String string) {
		this.textApplication.setText(string);
	}
}