/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.util;

import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/**
 * パースペクティブユーティリティクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PerspectiveUtil {

    /**
     * パースペクティブをクローズ
     * 
     * @param perspectivesId
     */
    public static void closePerspective(String perspectivesId) {
    	
    	IWorkbenchPage page = 
    		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

		IPerspectiveDescriptor[] openPerspectives = page.getOpenPerspectives();

		for(int i = 0; i < openPerspectives.length; i++){
			String id = openPerspectives[i].getId();
			if(id.equals(perspectivesId)){
				page.closePerspective(openPerspectives[i], true, true);
			}
		}
    }
    
    /**
     * Hinemosの全パースペクティブをクローズ
     * 
     */
    public static void closeAllHinemosPerspective() {
    	
    	IWorkbenchPage page = 
    		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

		IPerspectiveDescriptor[] openPerspectives = page.getOpenPerspectives();

		for(int i = 0; i < openPerspectives.length; i++){
			String id = openPerspectives[i].getId();
			if(id.equals("com.clustercontrol.repository.RepositoryPerspective") || 
					id.equals("com.clustercontrol.monitor.ui.MonitorPerspective") || 
					id.equals("com.clustercontrol.jobmanagement.ui.JobManagementPerspective") || 
					id.equals("com.clustercontrol.collectiverun.ui.CollectiveRunPerspective") || 
					id.equals("com.clustercontrol.performance.PerformancePerspective") || 
					id.equals("com.clustercontrol.accesscontrol.ui.AccessControlPerspective") || 
					id.equals("com.clustercontrol.calendar.ui.CalendarPerspective")){
				page.closePerspective(openPerspectives[i], true, true);
			}
		}
    }
}