/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;

import com.clustercontrol.bean.OutputFormConstant;

/**
 * 帳票を出力するクラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ReportGenerator {
	
	/** jasperパス */
	protected String m_jasperPath;
	
	/** 出力形式 */
	protected int m_outputForm;
	
	/**
	 * コンストラクタ
	 * 
	 * @param path jasperパス
	 */
	public ReportGenerator(String path, int form) {
		m_jasperPath = path;
		m_outputForm = form;
	}
	
	/**
	 * 帳票出力
	 * 
	 * @param destPath 帳票出力パス
	 * @param paramMap パラメータ
	 * @param collectionData データ一覧
	 * @return 帳票出力に成功した場合、true
	 */
	@SuppressWarnings("unchecked")
	public boolean run(String destPath, Map paramMap, Collection collectionData) {
		Thread cur = Thread.currentThread();
		ClassLoader save = cur.getContextClassLoader();
		
		try {
			cur.setContextClassLoader(JasperCompileManager.class.getClassLoader());
			
			// リソースを設定
			if(paramMap == null){
				paramMap = new HashMap();
			}
			paramMap.put("REPORT_RESOURCE_BUNDLE", Messages.getBundle());
			paramMap.put("REPORT_LOCALE", Locale.getDefault());
			
			JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(collectionData);
			JasperPrint print = JasperFillManager.fillReport(m_jasperPath, paramMap, ds);
			
			// 帳票出力
			if(m_outputForm == OutputFormConstant.TYPE_PDF){
				// PDFへ出力
				JasperExportManager.exportReportToPdfFile(print, destPath);
			}
			else if(m_outputForm == OutputFormConstant.TYPE_CSV){
				// CSVへ出力
				JRCsvExporter exporter = new JRCsvExporter();
				exporter.setParameter(JRExporterParameter.JASPER_PRINT, print);
				exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, destPath);
				exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, System.getProperty("file.encoding"));
				
				exporter.exportReport();
			}
			return true;
			
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		finally{
			cur.setContextClassLoader(save);
		}
	}
}