/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.collectiverun.action.ExecuteCollectiveRun;
import com.clustercontrol.collectiverun.composite.ParameterViewComposite;
import com.clustercontrol.collectiverun.dialog.RunConfirmedDialog;
import com.clustercontrol.collectiverun.view.ParameterView;
import com.clustercontrol.util.PropertyUtil;

/**
 * 一括制御実行アクションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 *  
 */
public class CollectiveRunAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.collectiverun.accountcontrol.view.action.CollectiveRunAction";
	
    /** ビュー */
    private IViewPart viewPart = null;

    /**
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        viewPart = view;
    }

    /**
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        //プロパティシート
        ParameterView view = (ParameterView) this.viewPart
                .getAdapter(ParameterView.class);

        ParameterViewComposite parameterComposite = view.getComposite();
        Property data = parameterComposite.getInputData();
        String typeId = parameterComposite.getTypeId();
        String typeString = parameterComposite.getTypeString(typeId);

        if(typeId != null && typeString != null){
	        // 実行確認ダイアログを表示する
	        RunConfirmedDialog dialog = new RunConfirmedDialog(this.viewPart
	                .getSite().getShell());
	        PropertyUtil.setPropertyModify(data, PropertyConstant.MODIFY_NG);
	        dialog.setDate(data);
	        dialog.setType(typeString);
	
	        // OKボタン押下
	        if (dialog.open() == IDialogConstants.OK_ID) {
	            //実行
	            ExecuteCollectiveRun execute = new ExecuteCollectiveRun();
	            execute.execute(typeId, data);
	
	            parameterComposite.setInputData(data);
	        }
	        PropertyUtil.setPropertyModify(data, PropertyConstant.MODIFY_OK);
        }
    }

    /**
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}