
SET client_encoding = 'SQL_ASCII';
SET check_function_bodies = false;
SET client_min_messages = warning;

DELETE FROM cc_crun_cmd_param_mst;
DELETE FROM cc_crun_param_select_mst;
DELETE FROM cc_crun_param_mst;
DELETE FROM cc_crun_end_mst;
DELETE FROM cc_crun_cmd_mst;
DELETE FROM cc_crun_type_mst;

SET search_path = public, pg_catalog;

--
-- Data for Name: cc_crun_type_mst; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO cc_crun_type_mst (type_id, name_id, order_no) VALUES ('FILE', 'filesystem.management', 0);
INSERT INTO cc_crun_type_mst (type_id, name_id, order_no) VALUES ('INSTALL', 'installation.management', 1);
INSERT INTO cc_crun_type_mst (type_id, name_id, order_no) VALUES ('START_STOP', 'start.stop.management', 2);
INSERT INTO cc_crun_type_mst (type_id, name_id, order_no) VALUES ('USER', 'user.management', 3);

--
-- Data for Name: cc_crun_cmd_mst; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('ADD_USER', 'USER', 0, 'add.user', 1, '/opt/hinemos/lib/cr/useradd.sh');
INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('DELETE_USER', 'USER', 2, 'delete.user', 0, '/usr/sbin/userdel -r');
INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('MODIFY_USER', 'USER', 1, 'modify.user', 1, '/opt/hinemos/lib/cr/usermod.sh');
INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('REBOOT_LINUX', 'START_STOP', 0, 'reboot.linux', 0, '/sbin/reboot');
INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('SHUTDOWN_LINUX', 'START_STOP', 1, 'shutdown.linux', 0, '/sbin/poweroff');
INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('START_APACHE', 'START_STOP', 2, 'start.apache', 0, '/etc/init.d/httpd start');
INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('STOP_APACHE', 'START_STOP', 3, 'stop.apache', 0, '/etc/init.d/httpd stop');
INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('COPY_FILE', 'FILE', 0, 'copy.file', 1, '/opt/hinemos/lib/cr/cp.sh');
INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('MAKE_DIRECTORY', 'FILE', 1, 'make.directory', 1, '/opt/hinemos/lib/cr/mkdir.sh');
INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('REMOVE_FILE', 'FILE', 2, 'remove.file.directory', 1, '/opt/hinemos/lib/cr/rm.sh');
INSERT INTO cc_crun_cmd_mst (command_id, type_id, order_no, name_id, command_type, command) VALUES ('RPM_INSTALL', 'INSTALL', 0, 'rpm.installation', 1, '/opt/hinemos/lib/cr/rpminstall.sh');

--
-- Data for Name: cc_crun_end_mst; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('COPY_FILE', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('COPY_FILE', 1, 1, 9);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('REMOVE_FILE', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('MAKE_DIRECTORY', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('MAKE_DIRECTORY', 1, 1, 9);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('RPM_INSTALL', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('REBOOT_LINUX', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('SHUTDOWN_LINUX', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('START_APACHE', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('STOP_APACHE', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('ADD_USER', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('ADD_USER', 1, 1, 2);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('MODIFY_USER', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('MODIFY_USER', 1, 1, 2);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('DELETE_USER', 0, 0, 0);
INSERT INTO cc_crun_end_mst (command_id, end_status, end_value_from, end_value_to) VALUES ('RPM_INSTALL', 1, 1, 9);

--
-- Data for Name: cc_crun_param_mst; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('SOURCE_FILE', 'source.file', 0);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('USER_NAME', 'user.name', 0);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('GROUP_NAME', 'group.name', 0);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('DIRECTORY_NAME', 'directory.name', 0);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('FILE', 'file', 0);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('FILE_DIRECTORY', 'file.directory', 0);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('DESTINATION', 'destination', 0);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('DIRECTORY_PERMISSION', 'file.access.permission', 2);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('FILE_PERMISSION', 'file.access.permission', 2);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('UID', 'uid', 0);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('PASSWORD', 'password', 1);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('SECONDARY_GROUP_NAME', 'secondary.group.name', 0);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('LOGIN_SHELL', 'login.shell', 2);
INSERT INTO cc_crun_param_mst (param_id, name_id, param_type) VALUES ('HOME_DIRECTORY', 'home.directory', 0);

--
-- Data for Name: cc_crun_param_select_mst; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('LOGIN_SHELL', 0, '/bin/sh', '/bin/sh');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('LOGIN_SHELL', 1, '/bin/bash', '/bin/bash');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('LOGIN_SHELL', 2, '/bin/ksh', '/bin/ksh');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('LOGIN_SHELL', 3, '/bin/tcsh', '/bin/tcsh');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('LOGIN_SHELL', 4, '/bin/csh', '/bin/csh');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('DIRECTORY_PERMISSION', 0, 'rwx------', '700');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('DIRECTORY_PERMISSION', 1, 'rwxrwx---', '770');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('DIRECTORY_PERMISSION', 2, 'rwxr-x---', '750');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('DIRECTORY_PERMISSION', 3, 'rwxr-xr-x', '755');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('DIRECTORY_PERMISSION', 4, 'r-x------', '500');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('DIRECTORY_PERMISSION', 5, 'r-xr-x---', '550');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('DIRECTORY_PERMISSION', 6, 'r-xr-xr-x', '555');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 0, 'rwx------', '700');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 1, 'rwxrwx---', '770');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 2, 'rwxr-x---', '750');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 3, 'rwxr-xr-x', '755');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 4, 'rw-------', '600');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 5, 'rw-rw----', '660');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 6, 'rw-r-----', '640');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 7, 'rw-r--r--', '644');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 8, 'r--------', '400');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 9, 'r--r-----', '440');
INSERT INTO cc_crun_param_select_mst (param_id, order_no, name_id, param_value) VALUES ('FILE_PERMISSION', 10, 'r--r--r--', '444');

--
-- Data for Name: cc_crun_cmd_param_mst; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('ADD_USER', 'UID', 0, '-u');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('ADD_USER', 'PASSWORD', 2, '-p');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('ADD_USER', 'GROUP_NAME', 3, '-g');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('ADD_USER', 'SECONDARY_GROUP_NAME', 4, '-G');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('ADD_USER', 'LOGIN_SHELL', 5, '-s');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('ADD_USER', 'HOME_DIRECTORY', 6, '-d');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('ADD_USER', 'USER_NAME', 1, NULL);
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('MODIFY_USER', 'PASSWORD', 1, '-p');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('MODIFY_USER', 'USER_NAME', 0, NULL);
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('MODIFY_USER', 'LOGIN_SHELL', 4, '-s');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('MODIFY_USER', 'GROUP_NAME', 2, '-g');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('MODIFY_USER', 'SECONDARY_GROUP_NAME', 3, '-G');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('DELETE_USER', 'USER_NAME', 0, NULL);
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('RPM_INSTALL', 'FILE', 0, NULL);
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('COPY_FILE', 'SOURCE_FILE', 0, NULL);
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('COPY_FILE', 'DESTINATION', 1, '-d');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('COPY_FILE', 'FILE_PERMISSION', 4, '-m');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('COPY_FILE', 'GROUP_NAME', 3, '-g');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('COPY_FILE', 'USER_NAME', 2, '-u');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('REMOVE_FILE', 'FILE_DIRECTORY', 0, NULL);
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('REMOVE_FILE', 'USER_NAME', 1, '-u');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('MAKE_DIRECTORY', 'DIRECTORY_NAME', 0, NULL);
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('MAKE_DIRECTORY', 'USER_NAME', 1, '-u');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('MAKE_DIRECTORY', 'GROUP_NAME', 2, '-g');
INSERT INTO cc_crun_cmd_param_mst (command_id, param_id, order_no, param_prefix) VALUES ('MAKE_DIRECTORY', 'DIRECTORY_PERMISSION', 3, '-m');


