/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.ejb.session;

import java.io.IOException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

import com.clustercontrol.bean.PluginConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.DetailTableDefine;
import com.clustercontrol.collectiverun.bean.HistoryTableDefine;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.collectiverun.factory.DeleteMaster;
import com.clustercontrol.collectiverun.factory.HistoryFilterProperty;
import com.clustercontrol.collectiverun.factory.ModifyMaster;
import com.clustercontrol.collectiverun.factory.OperationRun;
import com.clustercontrol.collectiverun.factory.ParameterProperty;
import com.clustercontrol.collectiverun.factory.SelectMaster;
import com.clustercontrol.collectiverun.factory.SelectSession;
import com.clustercontrol.commons.ejb.UsedFacilityException;
import com.clustercontrol.commons.ejb.session.CheckFacility;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.util.QuartzUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;


/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="CollectiveRunController"	
 *           jndi-name="CollectiveRunController"
 *           type="Stateless" 
 *           transaction-type="Container"
 *           
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=JobController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class CollectiveRunControllerBean implements javax.ejb.SessionBean, CheckFacility {
    protected static Log m_log = LogFactory.getLog( CollectiveRunControllerBean.class );
    public static final String GROUP_NAME = "CRUN_MANAGEMENT";
    
    /**
     * 履歴テーブル定義取得
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
     * 
     * @param locale
     * @return TableColumnInfoの配列
     */
    @SuppressWarnings("unchecked")
	public ArrayList getHistoryTableDefine(Locale locale) {
        //テーブル定義配列
        ArrayList tableDefine = new ArrayList();
        
        tableDefine.add(HistoryTableDefine.STATUS, 
                new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.CRUN_STATUS, 80, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.SESSION_ID, 
                new TableColumnInfo(Messages.getString("session.id", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.START_TIME, 
                new TableColumnInfo(Messages.getString("start.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.END_TIME, 
                new TableColumnInfo(Messages.getString("end.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.TYPE, 
                new TableColumnInfo(Messages.getString("type", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.NAME, 
                new TableColumnInfo(Messages.getString("name", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.FACILITY_ID, 
                new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.SCOPE, 
                new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.TOTAL, 
                new TableColumnInfo(Messages.getString("total", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.NORMAL, 
                new TableColumnInfo(Messages.getString("successful", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.WARNING, 
                new TableColumnInfo(Messages.getString("warning", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.ABNORMAL, 
                new TableColumnInfo(Messages.getString("failed", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.WAITING, 
                new TableColumnInfo(Messages.getString("waiting", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(HistoryTableDefine.RUNNING, 
                new TableColumnInfo(Messages.getString("running", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        
        return tableDefine;
    }
    
    /**
     * 詳細テーブル定義取得
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
     * 
     * @param locale
     * @return TableColumnInfoの配列
     */
    @SuppressWarnings("unchecked")
	public ArrayList getDetailTableDefine(Locale locale) {
        //テーブル定義配列
        ArrayList tableDefine = new ArrayList();
        
        tableDefine.add(DetailTableDefine.STATUS, 
                new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.CRUN_STATUS, 80, SWT.LEFT));
        tableDefine.add(DetailTableDefine.END_STATUS, 
                new TableColumnInfo(Messages.getString("end.status", locale), TableColumnInfo.END_STATUS, 70, SWT.LEFT));
        tableDefine.add(DetailTableDefine.RETURN_VALUE, 
                new TableColumnInfo(Messages.getString("return.value", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
        tableDefine.add(DetailTableDefine.FACILITY_ID, 
                new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
        tableDefine.add(DetailTableDefine.FACILITY_NAME, 
                new TableColumnInfo(Messages.getString("facility.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
        tableDefine.add(DetailTableDefine.START_TIME, 
                new TableColumnInfo(Messages.getString("start.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
        tableDefine.add(DetailTableDefine.END_TIME, 
                new TableColumnInfo(Messages.getString("end.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
        tableDefine.add(DetailTableDefine.MESSAGE, 
                new TableColumnInfo(Messages.getString("message", locale), TableColumnInfo.TEXT_DIALOG, 300, SWT.LEFT));
        
        return tableDefine;
    }
    
    /**
     * パラメータ用プロパティ取得
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     * 
     * @param sessionId
     * @param locale
     * @return
     */
    public Property getParameterPropertyBySessionId(String sessionId, Locale locale) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getPropertyBySessionId(sessionId, locale);
    }
    
    /**
     * パラメータ用プロパティ取得
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     * 
     * @param typeId
     * @param locale
     * @return
     */
    public Property getParameterProperty(String typeId, Locale locale) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getProperty(typeId, locale);
    }
    
    /**
     * 種別ID取得
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     * 
     * @param sessionId
     * @return
     */
    public String getParameterTypeId(String sessionId) {
        ParameterProperty propaerty = new ParameterProperty();
        return propaerty.getTypeId(sessionId);
    }
    
	/**
	 * 履歴フィルタ用プロパティ取得
	 * 
	 * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
	 * 
	 * @param locale
	 * @return 
	 * @throws FinderException 
	 * @throws NamingException 
	 */
	public Property getHistoryFilterProperty(Locale locale) throws FinderException, NamingException {
	    Property historyFilterProperty = null;
		try {
			HistoryFilterProperty history = new HistoryFilterProperty();
			historyFilterProperty = history.getProperty(locale);
		} catch (FinderException e) {
			m_log.debug("getHistoryFilterProperty() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		return historyFilterProperty;
	}
    
    /**
     * 履歴一覧取得
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
     * 
     * @param locale
     * @param histories
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    public ViewListInfo getHistoryList(Locale locale, int histories) throws FinderException, NamingException {
        ViewListInfo historyList = null;
		try {
			SelectSession select = new SelectSession();
			historyList = select.getHistoryList(locale, histories);
		} catch (FinderException e) {
			m_log.debug("getHistoryList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		} 
        return historyList; 
    }
    
    /**
     * 履歴一覧取得
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
     * 
     * @param property
     * @param locale
     * @param histories
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    public ViewListInfo getHistoryList(Property property, Locale locale, int histories) throws FinderException, NamingException {
        ViewListInfo historyList = null;
		try {
			SelectSession select = new SelectSession();
			historyList = select.getHistoryList(property, locale, histories);
		} catch (FinderException e) {
			m_log.debug("getHistoryList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
        return historyList; 
    }
    
    /**
     * 詳細一覧取得
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
     * 
     * @param sessionId
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    public ArrayList getDetailList(String sessionId, Locale locale) throws FinderException, NamingException {
        ArrayList detailList = null;
		try {
			SelectSession select = new SelectSession();
			detailList = select.getDetailList(sessionId, locale);
		} catch (FinderException e) {
			m_log.debug("getDetailList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
        return detailList;
    }
    
    /**
     * 一括制御実行処理
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunExecute"
     *     method-intf="Remote"
     * 
     * @param typeId
     * @param property
     * @param locale
     * @throws Exception
     */
    public void run(String typeId, Property property, Locale locale) throws Exception {
        CollectiveRunControllerLocal controller = 
            CollectiveRunControllerUtil.getLocalHome().create();
        
	    //実行履歴データ作成
	    String sessionId;
        try {
            sessionId = controller.createSession(typeId, property, locale);
        } catch (Exception e) {
            AplLogger apllog = new AplLogger("CR","cr");
            apllog.put("SYS","002");
            throw e;
        }
        
        //実行
        try {
            controller.run(sessionId);
	    } catch (Exception e) {
            AplLogger apllog = new AplLogger("CR","cr");
            apllog.put("SYS","001");
	        throw e;
	    }
    }
    
    /**
     * 実行履歴データ作成処理
     * 
     * @ejb.interface-method
     *     view-type="local"
     * 
	 * @ejb.transaction
	 *     type="RequiresNew"
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunExecute"
     *     method-intf="Remote"
     * 
     * @param type
     * @param property
     * @param locale
     * @return
     * @throws CreateException
     * @throws FinderException
     * @throws NamingException
     */
    public String createSession(String typeId, Property property, Locale locale) throws CreateException, FinderException, NamingException {
        OperationRun operation = new OperationRun();
    	//実行履歴データ作成
        return operation.createSession(typeId, property, locale);
    }
    
    /**
     * 一括制御実行処理
     * 
     * @ejb.interface-method
     *     view-type="local"
     * 
	 * @ejb.transaction
	 *     type="RequiresNew"
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunExecute"
     *     method-intf="Remote"
     * 
     * @param sessionId
     * @throws CreateException
     * @throws FinderException
     * @throws NamingException
     * @throws IOException
     */
    public void run(String sessionId) throws CreateException, FinderException, NamingException, IOException {
        OperationRun operation = new OperationRun();
        operation.run(sessionId);
    }
    
    /**
     * ノード終了処理
     * 
     * @ejb.interface-method
     * 
	 * @ejb.permission
     *     role-name="CollectiveRunExecute"
     *     method-intf="Remote"
     * 
     * @param info
     * @throws FinderException
     * @throws NamingException
     */
    public void endNode(RunResultInfo info) throws FinderException, NamingException {
        OperationRun operation = new OperationRun();
        operation.endNode(info);
    }
    
    /**
     * セッション終了チェック処理
     * 
     * @ejb.interface-method
     * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
     * 
     * @param info
     * @throws FinderException
     * @throws NamingException
     */
    public void checkEndSession() throws FinderException, NamingException {
    	OperationRun operation = new OperationRun();
    	operation.checkEndSession();
    }
    
    /**
     * 一括制御階層ツリー取得
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
     * @jboss.method-attributes
     *     read-only="true"
     * 
     * @param locale
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    public TreeItem getTree(Locale locale) throws FinderException, NamingException {
    	SelectMaster select = new SelectMaster();
    	return select.getTree(locale);
    }
    
    /**
     * 一括制御マスタ情報更新
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunWrite"
     *     method-intf="Remote"
     * 
     * @param info
     * @param parentInfo
     * @throws NamingException
     * @throws CreateException
     * @throws RemoveException 
     */
    public void updateMaster(ItemInfo info, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException {
    	ModifyMaster modify = new ModifyMaster();

    	try {
	    	modify.update(info, parentInfo);
        } catch (NamingException e) {
        	outputErrorUpdateMaster(info, parentInfo, e);
            throw e;
        } catch (CreateException e) {
        	outputErrorUpdateMaster(info, parentInfo, e);
            throw e;
        } catch (RemoveException e) {
        	outputErrorUpdateMaster(info, parentInfo, e);
            throw e;
        }
    }
    
    /**
     * 一括制御マスタ情報更新時のエラー出力
     * 
     * @param info
     * @param parentInfo
     * @param e
     */
    protected void outputErrorUpdateMaster(ItemInfo info, ItemInfo parentInfo, Exception e) {

		if(info == null || parentInfo == null){
			return;
		}
		
		String id = "";
		String parentId = "";
		if(info.getType() == ItemConstant.TYPE_TYPE){
			id = ((TypeInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			id = ((CommandInfo)info).getId();
			parentId = ((TypeInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			id = ((CommandParameterInfo)info).getId();
			parentId = ((CommandInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			id = ((ParameterInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			id = String.valueOf(((ParameterSelectInfo)info).getOrderNo());
			parentId = ((ParameterSelectInfo)info).getId();
		}
    	
        AplLogger apllog = new AplLogger("CR","cr");
        String[] args = { String.valueOf(info.getType()), id, parentId };
        apllog.put("SYS", "007", args);
        m_log.debug("updateMaster() : " + e.getMessage());
    }
    
    /**
     * 一括制御マスタ情報更新
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunWrite"
     *     method-intf="Remote"
     * 
     * @param info
     * @param parentInfo
     * @throws EJBException
     * @throws FinderException
     * @throws NamingException
     * @throws RemoveException
     */
    public void deleteMaster(ItemInfo info, ItemInfo parentInfo) throws EJBException, FinderException, NamingException, RemoveException {
    	DeleteMaster delete = new DeleteMaster();

    	try {
    		delete.delete(info, parentInfo);
        } catch (EJBException e) {
        	outputErrorDeleteMaster(info, parentInfo, e);
            throw e;
        } catch (FinderException e) {
        	outputErrorDeleteMaster(info, parentInfo, e);
            throw e;
        } catch (NamingException e) {
        	outputErrorDeleteMaster(info, parentInfo, e);
            throw e;
        } catch (RemoveException e) {
        	outputErrorDeleteMaster(info, parentInfo, e);
            throw e;
        }
    }
    
    /**
     * 一括制御マスタ情報削除時のエラー出力
     * 
     * @param info
     * @param parentInfo
     * @param e
     */
    protected void outputErrorDeleteMaster(ItemInfo info, ItemInfo parentInfo, Exception e) {

		if(info == null || parentInfo == null){
			return;
		}
		
		String id = "";
		String parentId = "";
		if(info.getType() == ItemConstant.TYPE_TYPE){
			id = ((TypeInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			id = ((CommandInfo)info).getId();
			parentId = ((TypeInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			id = ((CommandParameterInfo)info).getId();
			parentId = ((CommandInfo)parentInfo).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			id = ((ParameterInfo)info).getId();
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			id = String.valueOf(((ParameterSelectInfo)info).getOrderNo());
			parentId = ((ParameterSelectInfo)info).getId();
		}
    	
        AplLogger apllog = new AplLogger("CR","cr");
        String[] args = { String.valueOf(info.getType()), id, parentId };
        apllog.put("SYS", "008", args);
        m_log.debug("deleteMaster() : " + e.getMessage());
    }
    
    /**
     * 一括制御マスタ情報更新
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunWrite"
     *     method-intf="Remote"
     * 
     * @param info1
     * @param info2
     * @param parentInfo
     * @throws NamingException
     * @throws CreateException
     * @throws RemoveException
     * @throws FinderException
     */
    public void changeOrder(ItemInfo info1, ItemInfo info2, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException, FinderException {
    	ModifyMaster modify = new ModifyMaster();
    	modify.changeOrder(info1, info2, parentInfo);
    }
    
    /**
     * 種別文字列リスト取得
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
     * @jboss.method-attributes
     *     read-only="true"
     * 
     * @param locale
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    public List getTypeStringList(Locale locale) throws FinderException, NamingException {
    	List typeStringList = null;
		try {
			typeStringList = SelectMaster.getTypeStringList(locale);
		} catch (FinderException e) {
			m_log.debug("getTypeStringList() -> " + e.getMessage());
		} catch (NamingException e) {
			throw e;
		}
    	return typeStringList; 
    }
    
    /**
     * 種別ハッシュマップ取得
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @ejb.permission
     *     role-name="CollectiveRunRead"
     *     method-intf="Remote"
     *     
     * @jboss.method-attributes
     *     read-only="true"
     * 
     * @param locale
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    public HashMap getTypeHashMap(Locale locale) throws FinderException, NamingException {
    	HashMap typeHashMap = null;
		try {
			typeHashMap = SelectMaster.getTypeHashMap(locale);
		} catch (FinderException e) {
			m_log.debug(e.getMessage());
		} catch (NamingException e) {
			throw e;
		} 
    	return typeHashMap;
    }
    
    /**
     * Quartzへ登録
     * 
     * @ejb.interface-method
     * @generated
     * 
 	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
     * 
     * @param cronString
     * @throws NamingException
     * @throws ParseException
     * @throws SchedulerException
     */
    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        //QuartzのSchedulerをルックアップ
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
        try {
            //ジョブ削除
        	manager.deleteSchedule(CollectiveRunControllerHome.JNDI_NAME, 
                    GROUP_NAME);
        } catch (SchedulerException e) {
            m_log.debug("addQuartz() : deleteJob error = " + e.getMessage());
        } catch (RemoteException e) {
        	//TODO 未実装（例外処理）
		}
        
        //JobDetail作成
        JobDetail job = new JobDetail(
        		CollectiveRunControllerHome.JNDI_NAME, 
                GROUP_NAME, 
                EJBInvokerJob.class);
        
        String serverName = System.getProperty("jboss.server.name");
	    if(serverName.equals("all")){
	        job.getJobDataMap().put(
	                EJBInvokerJob.PROVIDER_URL, 
	                "jnp://localhost:1100");
	    }
	    
        //ジョブ完了時に削除されないようにする。
        job.setDurability(true);
	    //ジョブ実行失敗時に再実行するようにする。
	    job.setRequestsRecovery(true);
	    
        //JobDetailに呼び出すクラスとメソッドを設定
        job.getJobDataMap().put(
                EJBInvokerJob.EJB_JNDI_NAME_KEY, 
                CollectiveRunControllerHome.JNDI_NAME);
        job.getJobDataMap().put(
                EJBInvokerJob.EJB_METHOD_KEY, 
                "checkEndSession");
        
        //JobDetailに呼び出すメソッドの引数を設定
        Object[] jdArgs = new Object[0];
        job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
        
        //CronTriggerを作成
        CronTrigger cronTrigger = new CronTrigger(CollectiveRunControllerHome.JNDI_NAME, GROUP_NAME);
        
        //スケジュールを設定
        cronTrigger.setCronExpression(cronString);
        
        //Schedulerにジョブを登録する
        try {
			manager.addSchedule(job, cronTrigger);
		} catch (RemoteException e) {
        	//FIXME RemoteException未実装
		}
    }
    
    /**
     * Quartzから削除
     * 
     * @ejb.interface-method
     * @generated
     * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
     * 
     * @throws NamingException
     * @throws ParseException
     * @throws SchedulerException
     */
    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        //QuartzのSchedulerをルックアップ
    	QuartzManager manager = QuartzUtil.getQuartzManager();
		
        try {
            //ジョブ削除
        	manager.deleteSchedule(CollectiveRunControllerHome.JNDI_NAME, 
                    GROUP_NAME);
        } catch (SchedulerException e) {
            m_log.debug("deleteQuartz() : deleteJob error = " + e.getMessage());
        } catch (RemoteException e) {
        	//TODO 未実装（例外処理）        	
		}
    }
    
	/**
	 * ファシリティIDが使用されているかチェックします。
	 * <P>
	 * 使用されていたら、UsedFacilityException がスローされる。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="CollectiveRunRead"
	 *     method-intf="Remote"
	 *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param facilityId ファシリティ
	 * @throws UsedFacilityException
	 * 
	 * @see com.clustercontrol.commons.ejb.session.CheckFacility#isUseFacilityId(java.lang.String)
	 * @see com.clustercontrol.bean.PluginConstant;
	 */
	public void isUseFacilityId(String facilityId) throws UsedFacilityException {
		try {
			Collection ct = null;
			
			// ファシリティIDが使用されているセッションを取得する。
			ct = CRunSessionUtil.getLocalHome().findByFacilityId(facilityId);
			if(ct != null && ct.size() > 0) {
				Iterator itr = ct.iterator();
				while(itr.hasNext()){
					//セッションを取得
					CRunSessionLocal session = (CRunSessionLocal)itr.next();
					//セッションの実行状態が終了の場合、UsedFacilityExceptionをスロー
					if(session.getStatus().intValue() != StatusConstant.TYPE_END){
						throw new UsedFacilityException(PluginConstant.TYPE_COLLECTIVERUN);
					}
				}
			}
			
			// ファシリティIDが使用されているセッションディテールを取得する。
			ct = null;
			ct = CRunSessionDetailUtil.getLocalHome().findByFacilityId(facilityId);
			if(ct != null && ct.size() > 0) {
				Iterator itr = ct.iterator();
				while(itr.hasNext()){
					//セッションディテールを取得
					CRunSessionDetailLocal sessionDetail = (CRunSessionDetailLocal)itr.next();
					//セッションディテールの実行状態が終了の場合、UsedFacilityExceptionをスロー
					if(sessionDetail.getStatus().intValue() != StatusConstant.TYPE_END){
						throw new UsedFacilityException(PluginConstant.TYPE_COLLECTIVERUN);
					}
				}
			}
			
		} catch (FinderException e) {
			m_log.debug("isUseFacilityId() : " + e.getMessage());
		} catch (NamingException e) {
			m_log.debug("isUseFacilityId() : " + e.getMessage());
		}
	}
}
