/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.view.JobListView;

/**
 * 同一階層のジョブツリーアイテムを取得するクラスです
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobTreeOneLevel {
	
	/**
	 * ジョブ[一覧]ビューのジョブツリー情報から、<BR>
	 * 引数で渡された親ジョブIDの直下のジョブツリーアイテムを取得する。<BR><BR>
	 * 取得したジョブツリーアイテムから、<BR>
	 * 引数で渡されたジョブIDと一致するジョブツリーアイテムを除いたジョブツリーアイテムを返す。
	 * 
	 * @return ジョブツリー情報{@link com.clustercontrol.jobmanagement.bean.JobTreeItem}の階層オブジェクト
	 */
	public JobTreeItem getJobTreeOneLevel(String parentJobId, String jobId) {
		//アクティブページを手に入れる
		IWorkbenchPage page = PlatformUI.getWorkbench()
		.getActiveWorkbenchWindow().getActivePage();
		IViewPart viewPart = page.findView(JobListView.ID);
		JobListView view = (JobListView) viewPart.getAdapter(JobListView.class);
		JobTreeComposite composite = view.getJobTreeComposite();
		JobTreeItem tree = (JobTreeItem) composite.getTreeViewer().getInput();
		JobTreeItem top = tree.getChildren(0);
		JobTreeItem item = findJobTreeItem(parentJobId, tree);
		
		JobTreeItem treeitem = new JobTreeItem(null,
				copyJobInfo(tree.getData()));
		JobTreeItem topItem = new JobTreeItem(treeitem, copyJobInfo(top
				.getData()));
		
		for (int i = 0; i < item.getChildren().length; i++) {
			JobTreeItem child = item.getChildren(i);
			if (jobId.compareTo(child.getData().getId()) != 0) {
				@SuppressWarnings("unused")
				JobTreeItem childItem = new JobTreeItem(topItem,
						copyJobInfo(child.getData()));
			}
		}
		
		return treeitem;
	}
	
	/**
	 * 引数で渡されたジョブ情報のコピーインスタンスを作成する。
	 * 
	 * @param orgInfo コピー元ジョブ情報
	 * @return ジョブ情報
	 */
	protected JobInfo copyJobInfo(JobInfo orgInfo) {
		
		JobInfo info = new JobInfo(orgInfo.getId(), orgInfo.getName(), orgInfo
				.getType());
		
		return info;
	}
	
	/**
	 * ジョブツリーアイテムからジョブIDが一致するインスタンスを返す<BR>
	 * ジョブツリーアイテムのツリー階層の全てが検索対象
	 * 
	 * @param jobId ジョブID
	 * @param item ジョブツリーアイテム
	 * @return ジョブIDが一致したジョブツリーアイテム
	 */
	protected JobTreeItem findJobTreeItem(String jobId, JobTreeItem item) {
		JobTreeItem findItem = null;
		
		if (item.getData().getId().compareTo(jobId) == 0) {
			return item;
		}
		
		for (int i = 0; i < item.getChildren().length; i++) {
			JobTreeItem childItem = item.getChildren(i);
			findItem = findJobTreeItem(jobId, childItem);
			if (findItem != null) {
				return findItem;
			}
		}
		
		return null;
	}
}