/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[一覧]ビューのジョブツリー情報を登録するクラスです。
 * 
 * マネージャにSessionBean経由でアクセスし、ジョブツリー情報を登録する
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RegisterJob {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、ジョブツリー情報を登録する
	 * 
	 * @param item ジョブツリー情報
	 * @return true=成功、false=失敗
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#registerJob(com.clustercontrol.jobmanagement.bean.JobTreeItem)
	 */
	public boolean registerJob(JobTreeItem item) {
		boolean result = false;
		
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		try {
			job.registerJob(item);
			result = true;
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		} catch (FinderException e) {
		} catch (NamingException e) {
		} catch (RemoveException e) {
		} catch (CreateException e) {
		}
		return result;
	}
}
