/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.dialog.JobDialog;
import com.clustercontrol.jobmanagement.view.JobListView;

/**
 * ジョブ[一覧]ビューの「ジョブネットの作成」のアクションクラスです。
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class CreateJobNetAction implements IViewActionDelegate {
	/** アクションID */
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.CreateJobNetAction";
    /** ビュー */
    protected IViewPart m_view;

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /**
     * ジョブ[一覧]ビューの「ジョブネットの作成」が押された場合に、ジョブネットを作成します。
     * <p>
	 * <ol>
	 * <li>ジョブ[一覧]ビューから親となるジョブツリーアイテムを取得します。</li>
	 * <li>ジョブネット用のジョブ情報を作成し、親のジョブツリーアイテムの子として追加します。</li>
	 * <li>ジョブ[ジョブネットの作成・変更]ダイアログを表示します。</li>
	 * <li>ジョブ[一覧]ビューを更新します。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.jobmanagement.dialog.JobDialog
     * @see com.clustercontrol.jobmanagement.view.JobListView
     * @see com.clustercontrol.jobmanagement.composite.JobTreeComposite
     */
    public void run(IAction action) {
        JobTreeItem item = null;
        JobTreeItem parent = null;

        if (m_view instanceof JobListView) {
            JobListView view = (JobListView) m_view
                    .getAdapter(JobListView.class);
            JobTreeComposite tree = view.getJobTreeComposite();
            parent = view.getSelectJobTreeItem();

            if (parent instanceof JobTreeItem) {
                item = new JobTreeItem(new JobInfo("", "",
                        JobConstant.TYPE_JOBNET));
                item.getData().setUpdate(true);
                item.getData().setWaitRule(new JobWaitRuleInfo());
                parent.addChildren(item);

                JobDialog dialog = new JobDialog(
                		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
                		false);
                dialog.setJobTreeItem(item);

                //ダイアログ表示
                if (dialog.open() == IDialogConstants.OK_ID) {
                    view.setUpdate(true);
                } else {
                    parent.removeChildren(item);
                }
                tree.getTreeViewer().refresh(parent);
                tree.getTreeViewer().setSelection(
                        new StructuredSelection(parent), true);
            }
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}