/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;

/**
 * ジョブ貼り付けするアクションクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PasteJobAction extends Action {
	/** ビュー */
    protected IViewPart m_view;
    
    /**
     * コンストラクタ
     * 
     * @param view ビュー
     */
    public PasteJobAction(IViewPart view) {
        m_view = view;
        
        setText(Messages.getString("paste"));
        setToolTipText(Messages.getString("paste"));
    }
    
    /**
     * ジョブ[一覧]ビューにて選択されたジョブツリーアイテムを取得します。<BR>
     * ジョブ[一覧]ビューにコピー元のジョブツリーアイテムとして設定します。
     * <p>
	 * <ol>
	 * <li>ジョブ[一覧]ビューにて選択されたジョブツリーアイテムを取得します。</li>
	 * <li>ジョブ[一覧]ビューからコピー元のジョブツリーアイテムを取得します。</li>
	 * <li>コピー元ジョブツリーアイテムから、ジョブツリーアイテムのコピーを作成します。</li>
	 * <li>ジョブツリーアイテムのコピーを選択されたジョブツリーアイテムの子として追加します。</li>
	 * </ol>
	 * 
     * @see org.eclipse.jface.action.IAction#run()
     * @see com.clustercontrol.jobmanagement.util.JobUtil#copy(JobTreeItem, JobTreeItem)
     * @see com.clustercontrol.jobmanagement.bean.JobTreeItem#addChildren(JobTreeItem)
     */
    public void run() {
        JobListView view = (JobListView)m_view.getAdapter(JobListView.class);
        JobTreeItem selectItem = view.getSelectJobTreeItem();
        JobTreeItem sourceItem = view.getCopyJobTreeItem();
        if(selectItem instanceof JobTreeItem && 
                sourceItem instanceof JobTreeItem){
            
            boolean copy = false;
            if(sourceItem.getData().getType() == JobConstant.TYPE_JOBUNIT){
                if(selectItem.getData().getType() == JobConstant.TYPE_COMPOSITE){
                    copy = true;
                }
            }
            else if(sourceItem.getData().getType() == JobConstant.TYPE_JOBNET){
                if(selectItem.getData().getType() == JobConstant.TYPE_JOBUNIT || 
                        selectItem.getData().getType() == JobConstant.TYPE_JOBNET){
                    copy = true;
                }
            }
            else if(sourceItem.getData().getType() == JobConstant.TYPE_JOB){
                if(selectItem.getData().getType() == JobConstant.TYPE_JOBUNIT || 
                        selectItem.getData().getType() == JobConstant.TYPE_JOBNET){
                    copy = true;
                }
            }
            else if(sourceItem.getData().getType() == JobConstant.TYPE_FILEJOB){
                if(selectItem.getData().getType() == JobConstant.TYPE_JOBUNIT || 
                        selectItem.getData().getType() == JobConstant.TYPE_JOBNET){
                    copy = true;
                }
            }
            if(copy){
                view.setUpdate(true);
                
                JobTreeItem top = (JobTreeItem)view.getJobTreeComposite().getTreeViewer().getInput();
                JobTreeItem copyItem = JobUtil.copy(sourceItem, top);
                selectItem.addChildren(copyItem);
                
                view.getJobTreeComposite().getTreeViewer().refresh(selectItem);
                view.getJobTreeComposite().getTreeViewer().setSelection(
                        new StructuredSelection(selectItem), true);
            }
        }
    }
}
