/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import com.clustercontrol.util.Messages;

/**
 * 待ち条件の種別を定数として格納するクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ConditionTypeConstant {
	
    /** AND条件 */
    public static final int TYPE_AND = 0;

    /** OR条件 */
    public static final int TYPE_OR = 1;

    /** AND条件 */
    public static final String STRING_AND = Messages.getString("and");

    /** OR条件 */
    public static final String STRING_OR = Messages.getString("or");

    /**
     * 種別から文字列に変換する
     * 
     * @param type 種別
     * @return 文字列
     */
    public static String typeToString(int type) {
        if (type == TYPE_AND) {
            return STRING_AND;
        } else if (type == TYPE_OR) {
            return STRING_OR;
        }
        return "";
    }

    /**
     * 文字列から種別に変換する
     * 
     * @param string 文字列 
     * @return 種別
     */
    public static int stringToType(String string) {
        if (string.equals(STRING_AND)) {
            return TYPE_AND;
        } else if (string.equals(STRING_OR)) {
            return TYPE_OR;
        }
        return -1;
    }
}