/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

/**
 * ジョブコマンド情報クラス<BR>
 * ジョブのコマンドに関する情報を格納するクラスです。
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobCommandInfo implements Serializable, Cloneable {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 333607610499761260L;
	
	/** ファシリティID */
	protected String m_facilityID;
	
	/** スコープ */
	protected String m_scope;
	
	/** スコープ処理 */
	protected int m_processingMethod;
	
	/** 起動コマンド */
	protected String m_startCommand;
	
	/** 停止コマンド */
	protected String m_stopCommand;
	
	/** 実効ユーザ */
	protected String m_user;
	
	/** コマンド実行失敗時終了フラグ */
	protected int m_errorEndFlg;
	
	/** コマンド実行失敗時終了値 */
	protected int m_errorEndValue;
	
	/**
	 * コマンド実行失敗時終了フラグを返す
	 * @return コマンド実行失敗時終了フラグ
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public int getErrorEndFlg() {
		return m_errorEndFlg;
	}
	
	/**
	 * コマンド実行失敗時終了フラグを設定する
	 * @param errorEndFlg コマンド実行失敗時終了フラグ
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setErrorEndFlg(int errorEndFlg) {
		this.m_errorEndFlg = errorEndFlg;
	}
	
	/**
	 * コマンド実行失敗時終了値を返す
	 * @return コマンド実行失敗時終了値
	 */
	public int getErrorEndValue() {
		return m_errorEndValue;
	}
	
	/**
	 * コマンド実行失敗時終了値を設定する
	 * @param errorEndValue コマンド実行失敗時終了値
	 */
	public void setErrorEndValue(int errorEndValue) {
		this.m_errorEndValue = errorEndValue;
	}
	
	/**
	 * スコープを返す
	 * @return スコープ
	 */
	public String getScope() {
		return m_scope;
	}
	
	/**
	 * スコープを設定する
	 * @param scope スコープ
	 */
	public void setScope(String scope) {
		this.m_scope = scope;
	}
	
	/**
	 * 起動コマンドを返す
	 * @return 起動コマンド
	 */
	public String getStartCommand() {
		return m_startCommand;
	}
	
	/**
	 * 起動コマンドを設定する
	 * @param startCommand 起動コマンド
	 */
	public void setStartCommand(String startCommand) {
		this.m_startCommand = startCommand;
	}
	
	/**
	 * ファシリティIDを返す
	 * @return ファシリティID
	 */
	public String getFacilityID() {
		return m_facilityID;
	}
	
	/**
	 * ファシリティIDを設定する
	 * @param facilityID ファシリティID
	 */
	public void setFacilityID(String facilityID) {
		this.m_facilityID = facilityID;
	}
	
	/**
	 * 停止コマンドを返す
	 * @return 停止コマンド
	 */
	public String getStopCommand() {
		return m_stopCommand;
	}
	
	/**
	 * 停止コマンドを設定する
	 * @param stopCommand 停止コマンド
	 */
	public void setStopCommand(String stopCommand) {
		this.m_stopCommand = stopCommand;
	}
	
	/**
	 * スコープ処理を返す
	 * @return スコープ処理
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public int getProcessingMethod() {
		return m_processingMethod;
	}
	
	/**
	 * スコープ処理を設定する
	 * @param processingMethod スコープ処理
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public void setProcessingMethod(int processingMethod) {
		this.m_processingMethod = processingMethod;
	}
	
	/**
	 * 実効ユーザを返す
	 * @return 実効ユーザ
	 */
	public String getUser() {
		return m_user;
	}
	
	/**
	 * 実効ユーザを設定する
	 * @param user 実効ユーザ
	 */
	public void setUser(String user) {
		this.m_user = user;
	}
	
	/**
	 * ジョブコマンド情報のクローンを作成する
	 * 
	 * @see java.lang.Object#clone()
	 */
	protected Object clone() {
		try {
			JobCommandInfo clone = (JobCommandInfo)super.clone();
			
			clone.setErrorEndFlg(this.getErrorEndFlg());
			clone.setErrorEndValue(this.getErrorEndValue());
			clone.setFacilityID(this.getFacilityID());
			clone.setProcessingMethod(this.getProcessingMethod());
			clone.setScope(this.getScope());
			clone.setStartCommand(this.getStartCommand());
			clone.setStopCommand(this.getStopCommand());
			clone.setUser(this.getUser());
			
			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}