/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAOImpl;


/**
 * ジョブ待ち条件ジョブ情報のBMP Entity Beanです。
 * 
 * @ejb.bean name="JobStartJobInfo"
 *           jndi-name="JobStartJobInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAO
 * @see com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAOImpl
 */
public abstract class JobStartJobInfoBean implements javax.ejb.EntityBean {
	/** セッションID */
    protected String session_id;
    /** ジョブID */
    protected String job_id;
    /** 判定対象ジョブID */
    protected String target_job_id;
    /** 判定対象種別 */
    protected Integer target_job_type;
    /** 値 */
    protected Integer target_job_end_value;
    
    /**
     * ジョブ待ち条件ジョブ情報を生成します。
     * 
     * @ejb.create-method 
     * 
     * @param session_id セッションID
     * @param job_id ジョブID
     * @param target_job_id 判定対象ジョブID
     * @param target_job_type 判定対象種別
     * @param target_job_end_value 値
     * @return プライマリキー
     * @throws javax.ejb.CreateException
     * 
     * @see com.clustercontrol.bean.JudgmentObjectConstant
     */
    public JobStartJobInfoPK ejbCreate(
            String session_id, 
            String job_id, 
            String target_job_id, 
            Integer target_job_type, 
            Integer target_job_end_value
            ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.job_id = job_id;
        this.target_job_id = target_job_id;
        this.target_job_type = target_job_type;
        this.target_job_end_value = target_job_end_value;
        return null;
    }

	/**
	 * 全てのジョブ待ち条件ジョブ情報を検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブ待ち条件ジョブ情報を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAOImpl#findByPrimaryKey(JobStartJobInfoPK)
	 */
	public JobStartJobInfoPK ejbFindByPrimaryKey(JobStartJobInfoPK pk) throws FinderException {
		return null;
	}

	/**
	 * セッションID、判定対象ジョブIDが一致するジョブ待ち条件ジョブ情報を検索します。
	 * 
	 * @param session_id セッションID
	 * @param target_job_id 判定対象ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAOImpl#findByTargetJobId(String, String)
	 */
	public Collection ejbFindByTargetJobId(java.lang.String session_id, java.lang.String target_job_id) throws FinderException {
		return null;
	}
	
	/**
	 * セッションID、ジョブIDが一致するジョブ待ち条件ジョブ情報を検索します。
	 * 
	 * @param session_id セッションID
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAOImpl#findBySessionIdAndJobId(String, String)
	 */
	public Collection ejbFindBySessionIdAndJobId(java.lang.String session_id, java.lang.String job_id) throws FinderException {
		return null;
	}

	/**
	 * セッションIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return セッションID
	 */
    public java.lang.String getSession_id() {
    	return session_id;
    }

	/**
	 * セッションIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param session_id セッションID
	 */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

	/**
	 * 判定対象ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 判定対象ジョブID
	 */
    public java.lang.String getTarget_job_id() {
    	return target_job_id;
    }

	/**
	 * 判定対象ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param target_job_id 判定対象ジョブID
	 */
    public void setTarget_job_id(java.lang.String target_job_id) {
    	this.target_job_id = target_job_id;
    }

	/**
	 * 判定対象種別を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 判定対象種別
	 * 
	 * @see com.clustercontrol.bean.JudgmentObjectConstant
	 */
    public java.lang.Integer getTarget_job_type() {
    	return target_job_type;
    }

	/**
	 * 判定対象種別を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param target_job_type 判定対象種別
	 * 
	 * @see com.clustercontrol.bean.JudgmentObjectConstant
	 */
    public void setTarget_job_type(
            java.lang.Integer target_job_type) {
    	this.target_job_type = target_job_type;
    }
    
	/**
	 * 値を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 値
	 */
    public java.lang.Integer getTarget_job_end_value() {
    	return target_job_end_value;
    }

	/**
	 * 値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param target_job_end_value 値
	 */
    public void setTarget_job_end_value(
            java.lang.Integer target_job_end_value) {
    	this.target_job_end_value = target_job_end_value;
    }

	/**
	 * ジョブ待ち条件情報を取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ待ち条件情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoBean#ejbFindByPrimaryKey(JobStartInfoPK)
	 */
    public JobStartInfoLocal getJobStartInfo() {
    	JobStartInfoLocal jobStartInfo = null;
		try {
			jobStartInfo = JobStartInfoUtil.getLocalHome().findByPrimaryKey(new JobStartInfoPK(getSession_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartInfo;
	}
    
	/**
	 * 履歴情報を作成する。<BR>
	 * ジョブ待ち条件情報をジョブ待ち条件マスタから作成します。
	 * 
	 * @ejb.home-method view-type="both"
	 * 
	 * @param sessionId セッションID
	 * @param jobs ジョブIDのコレクション
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAOImpl#makeSession(String, Collection)
	 */
    public void ejbHomeMakeSession(String sessionId,Collection jobs) throws javax.ejb.CreateException {
    	JobStartJobInfoDAOImpl jsjiDAO = new JobStartJobInfoDAOImpl(); 
    	
    	jsjiDAO.makeSession(sessionId,jobs);
    	  
    }
    
}
