/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.sql.Time;
import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * ジョブ待ち条件時刻マスタのBMP Entity Beanです。
 * 
 * @ejb.bean name="JobStartTimeMaster"
 *           jndi-name="JobStartTimeMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobStartTimeMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobStartTimeMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.jobmanagement.dao.JobStartTimeMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobStartTimeMasterDAOImpl
 */
public abstract class JobStartTimeMasterBean implements javax.ejb.EntityBean {
	/** ジョブID */
	protected String job_id;
	/** 時刻 */
    protected Time start_time;
	    
    /**
     * ジョブ待ち条件時刻マスタを生成します。
     * 
     * @ejb.create-method 
     * 
     * @param job_id ジョブID
     * @param start_time 時刻
     * @return プライマリーキー
     * @throws javax.ejb.CreateException
     */
    public JobStartTimeMasterPK ejbCreate(
            String job_id, 
            Time start_time
            ) throws javax.ejb.CreateException {
        this.job_id = job_id;
        this.start_time = start_time;
        return null;
    }

	/**
	 * 全てのジョブ待ち条件時刻マスタを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartTimeMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブ待ち条件時刻マスタを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartTimeMasterDAOImpl#findByPrimaryKey(JobStartTimeMasterPK)
	 */
	public JobStartTimeMasterPK ejbFindByPrimaryKey(JobStartTimeMasterPK pk) throws FinderException {
		return null;
	}
    
	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }
    
	/**
	 * 時刻を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 時刻
	 */
    public java.sql.Time getStart_time() {
    	return start_time;
    }

    /**
     * 時刻を設定する。
     * 
     * @ejb.interface-method
     * 
     * @param start_time 時刻
     */
    public void setStart_time(java.sql.Time start_time) {
    	this.start_time = start_time;
    }
    
	/**
	 * ジョブ待ち条件マスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ待ち条件マスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterBean#ejbFindByPrimaryKey(JobStartMasterPK)
	 */
    public JobStartMasterLocal getJobStartMaster() {
    	JobStartMasterLocal jobStartMaster = null;
		try {
			jobStartMaster = JobStartMasterUtil.getLocalHome().findByPrimaryKey(new JobStartMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartMaster;
	}
}
