/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.maintenance.action.GetMaintenance;
import com.clustercontrol.util.Messages;


/**
 * 履歴保存期間指定コンポジットクラスです。
 * 
 * @version 2.2.0
 * @since 2.2.0
 */
public class MaintenanceKeepListComposite extends Composite {

    // ----- instance フィールド ----- //

    /** 履歴保存期間ラベル */
	private Label labelMaintenanceKeep = null;
	
    /** 履歴保存期間指定コンボボックス */
    private Combo comboMaintenanceKeep = null;

    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     * @param labelFlg メンテナンス種別ラベル表示フラグ
     */
    public MaintenanceKeepListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        
        this.initialize(parent, labelFlg);
    }
    

    // ----- instance メソッド ----- //

    /**
     * コンポジットを生成・構築します。
     */
    private void initialize(Composite parent, boolean labelFlg) {
    	
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        if(labelFlg){
        	layout.numColumns = 15;	
        }
        else{
        	layout.numColumns = 10;
        }
        this.setLayout(layout);
        
        /*
         * メンテナンス種別
         */
        if(labelFlg){
            // ラベル
            this.labelMaintenanceKeep = new Label(this, SWT.NONE);
            gridData = new GridData();
            gridData.horizontalSpan = 5;
            gridData.horizontalAlignment = GridData.FILL;
            gridData.grabExcessHorizontalSpace = true;
            this.labelMaintenanceKeep.setLayoutData(gridData);
            this.labelMaintenanceKeep.setText(Messages.getString("maintenance.keep") + " : ");
        }
        
        // コンボボックス
        this.comboMaintenanceKeep = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.comboMaintenanceKeep.setLayoutData(gridData);
                
        this.update();
    }

    /**
     * コンポジットを更新します。
     * <p>
     * 
     */
    public void update() {
    	
    	// データ取得
        ArrayList list = new GetMaintenance().getMaintenanceKeepNameIdList();
        this.comboMaintenanceKeep.add("");
        
        if(list != null){
        	// 種別リスト
        	for(int index=0; index<list.size(); index++){
        		this.comboMaintenanceKeep.add(Messages.getString((String)list.get(index)));
        	}
        }
    }
    
    public int getIndex() {
    	return comboMaintenanceKeep.getSelectionIndex();    	
    }

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.comboMaintenanceKeep.setEnabled(enabled);
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#getText()
	 */
	public String getText() {
		return this.comboMaintenanceKeep.getText();
	}

	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#setText(java.lang.String)
	 */
	public void setText(String string) {
		this.comboMaintenanceKeep.setText(string);
	}
}