/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.bean;



/**
 * メンテナンス機能の削除対象外の期間定義を定数として格納するクラスです。
 *
 * @version 2.2.0
 * @since 2.2.0
 */
public class MaintenanceKeepMstConstant {
	
	//空白が0になるので注意
	public static final int ONE_WEEK_INDEX = 1;
	public static final int TWO_WEEKS_INDEX = 2;
	public static final int ONE_MONTH_INDEX = 3;
	public static final int TWO_MONTHS_INDEX = 4;
	public static final int THREE_MONTHS_INDEX = 5;
	public static final int SIX_MONTHS_INDEX = 6;
	public static final int ONE_YEAR_INDEX = 7;
	
	public static final String ONE_WEEK = "ONE_WEEK";
	public static final String TWO_WEEKS = "TWO_WEEKS";
	public static final String ONE_MONTH = "ONE_MONTH";
	public static final String TWO_MONTHS = "TWO_MONTHS";
	public static final String THREE_MONTHS = "THREE_MONTHS";
	public static final String SIX_MONTHS = "SIX_MONTHS";
	public static final String ONE_YEAR = "ONE_YEAR";
	
	public static final String ONE_WEEK_NAME = "maintenance.keep.one_week";
	public static final String TWO_WEEKS_NAME = "maintenance.keep.two_weeks";
	public static final String ONE_MONTH_NAME = "maintenance.keep.one_month";
	public static final String TWO_MONTHS_NAME = "maintenance.keep.two_months";
	public static final String THREE_MONTHS_NAME = "maintenance.keep.three_months";
	public static final String SIX_MONTHS_NAME = "maintenance.keep.six_months";
	public static final String ONE_YEAR_NAME = "maintenance.keep.one_year";
	
	public static String indexToKeepId(int index) {
		
		String ret = null;
		
		switch (index) {
		
		case ONE_WEEK_INDEX:
			ret = ONE_WEEK;
			break;
			
		case TWO_WEEKS_INDEX:
			ret = TWO_WEEKS;
			break;
			
		case ONE_MONTH_INDEX:
			ret = ONE_MONTH;
			break;
			
		case TWO_MONTHS_INDEX:
			ret = TWO_MONTHS;
			break;
			
		case THREE_MONTHS_INDEX:
			ret = THREE_MONTHS;
			break;
			
		case SIX_MONTHS_INDEX:
			ret = SIX_MONTHS;
			break;
			
		case ONE_YEAR_INDEX:
			ret = ONE_YEAR;
			break;			
		
		}
		
		return ret;
	}
	
	public static String keepIdToNameId(String keepId) {
		
		String ret = null;
		
		if (keepId.equals(ONE_WEEK)) {
			ret = ONE_WEEK_NAME;
			
		} else if (keepId.equals(TWO_WEEKS)) {
			ret = TWO_WEEKS_NAME;
			
		} else if (keepId.equals(ONE_MONTH)) {
			ret = ONE_MONTH_NAME;
			
		} else if (keepId.equals(TWO_MONTHS)) {
			ret = TWO_MONTHS_NAME;
			
		} else if (keepId.equals(THREE_MONTHS)) {
			ret = THREE_MONTHS_NAME;
			
		} else if (keepId.equals(SIX_MONTHS)) {
			ret = SIX_MONTHS_NAME;
			
		} else if (keepId.equals(ONE_YEAR)) {
			ret = ONE_YEAR_NAME;
			
		}

		return ret;
	}

	
}
