

-- 
-- TABLE: cc_event_log 
--

CREATE TABLE cc_event_log(
    monitor_id           VARCHAR(64)     NOT NULL,
    plugin_id            VARCHAR(64)     NOT NULL,
    generation_date      TIMESTAMP       NOT NULL,
    facility_id          VARCHAR(64)     NOT NULL,
    scope_text           VARCHAR(256)    NOT NULL,
    application          VARCHAR(64)     NOT NULL,
    message_id           VARCHAR(64)     NOT NULL,
    message              VARCHAR(256)    NOT NULL,
    message_org          TEXT,
    priority             SMALLINT        NOT NULL,
    confirm_flg          SMALLINT        NOT NULL,
    confirm_date         TIMESTAMP,
    duplication_count    SMALLINT        NOT NULL,
    output_date          TIMESTAMP       NOT NULL,
    inhibited_flg        SMALLINT        NOT NULL,
    CONSTRAINT p_key_cc_event_log PRIMARY KEY (monitor_id, plugin_id, output_date, facility_id)
) 
;


-- 
-- TABLE: cc_status_info 
--

CREATE TABLE cc_status_info(
    facility_id        VARCHAR(64)     NOT NULL,
    monitor_id         VARCHAR(64)     NOT NULL,
    plugin_id          VARCHAR(64)     NOT NULL,
    application        VARCHAR(64)     NOT NULL,
    message_id         VARCHAR(64)     NOT NULL,
    message            VARCHAR(256)    NOT NULL,
    priority           SMALLINT        NOT NULL,
    generation_date    TIMESTAMP       NOT NULL,
    output_date        TIMESTAMP       NOT NULL,
    expiration_flg     SMALLINT,
    expiration_date    TIMESTAMP,
    CONSTRAINT p_key_cc_status_info PRIMARY KEY (facility_id, monitor_id, plugin_id)
) 
;

-- 
-- TABLE: cc_event_multi_info 
--

CREATE TABLE cc_event_multi_info(
    monitor_id         VARCHAR(64)     NOT NULL,
    plugin_id          VARCHAR(64)     NOT NULL,
    facility_id        VARCHAR(64)     NOT NULL,
    output_date        TIMESTAMP       NOT NULL,
    multi_id           VARCHAR(64)     NOT NULL,
    duplication_count  SMALLINT        NOT NULL,
    CONSTRAINT p_key_cc_event_multi_info PRIMARY KEY (monitor_id, plugin_id, output_date, facility_id, multi_id)
) 
;

-- 
-- TABLE: cc_event_multi_info 
--

ALTER TABLE cc_event_multi_info ADD CONSTRAINT Refcc_event_log1 
    FOREIGN KEY (monitor_id, plugin_id, output_date, facility_id)
    REFERENCES cc_event_log(monitor_id, plugin_id, output_date, facility_id)
;

-- Index: idx_cc_event_log_1

-- DROP INDEX idx_cc_event_log_1;

CREATE INDEX idx_cc_event_log_1
  ON cc_event_log
  USING btree
  (monitor_id, plugin_id, generation_date, facility_id);

-- Index: idx_cc_event_log_2

-- DROP INDEX idx_cc_event_log_2;

CREATE INDEX idx_cc_event_log_2
  ON cc_event_log
  USING btree
  (monitor_id, plugin_id, generation_date, facility_id, inhibited_flg);