/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */
package com.clustercontrol.monitor.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EntityBean;
import javax.ejb.FinderException;

/**
 * ステータス情報のBMP Entity Beanです。
 * 
 * @ejb.bean name="StatusInfo"
 *           jndi-name="StatusInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.monitor.dao.StatusInfoDAO"
 * impl-class="com.clustercontrol.monitor.dao.StatusInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @see com.clustercontrol.monitor.dao.StatusInfoDAO
 * @see com.clustercontrol.monitor.dao.StatusInfoDAOImpl
 */
public abstract class StatusInfoBean implements EntityBean {
	
	/** ファシリティID。 */
	public String facilityId;
	
	/** 監視項目ID。 */
	public String monitorId;
	
	/** プラグインID。 */
	public String pluginId;
	
	/** アプリケーション。 */
	public String application;
	
	/** メッセージID。 */
	public String messageId;
	
	/** メッセージ。 */
	public String message;
	
	/**
	 * 重要度。
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public Integer priority;
	
	/** 出力日時。 */
	public Timestamp generationDate;
	
	/** 最終変更日時。 */
	public Timestamp outputDate;
	
	/**
	 * 存続期間経過後の処理の制御フラグ。
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public Integer expirationFlg;
	
	/** 存続期間日時。*/
	public Timestamp expirationDate;
	
	/**
	 * ステータス情報を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param facilityId ファシリティID
	 * @param monitorId 監視項目ID
	 * @param pluginId プラグインID
	 * @param application アプリケーション
	 * @param messageId メッセージID
	 * @param message メッセージ
	 * @param priority 重要度
	 * @param generationDate 出力日時
	 * @param outputDate 最終変更日時
	 * @param expirationFlg 存続期間経過後の処理の制御フラグ
	 * @param expirationDate 存続期間日時
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAOImpl#create(StatusInfoBean)
	 */
	public com.clustercontrol.monitor.ejb.entity.StatusInfoPK ejbCreate(
			String facilityId, String monitorId, String pluginId,
			String application, String messageId, String message,
			Integer priority, Timestamp generationDate, Timestamp outputDate,
			Integer expirationFlg, Timestamp expirationDate)
	throws javax.ejb.CreateException {
		
		this.facilityId = facilityId;
		this.monitorId = monitorId;
		this.pluginId = pluginId;
		this.application = application;
		this.messageId = messageId;
		this.message = message;
		this.priority = priority;
		this.generationDate = generationDate;
		this.outputDate = outputDate;
		this.expirationFlg = expirationFlg;
		this.expirationDate = expirationDate;
		
		return null;
	}
	
	/**
	 * 全てのステータス情報を検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するステータス情報を検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAOImpl#findByPrimaryKey(StatusInfoPK)
	 */
	public StatusInfoPK ejbFindByPrimaryKey(StatusInfoPK pk)
	throws FinderException {
		return null;
	}
	
	/**
	 * 指定した引数に一致するステータス情報を検索します。
	 * 
	 * @param facilityId ファシリティIDの配列
	 * @param priority 重要度
	 * @param outputFromDate 最終変更日時（開始）
	 * @param outputToDate 最終変更日時（終了）
	 * @param generationFromDate 出力日時（開始）
	 * @param generationToDate 出力日時（終了）
	 * @param application アプリケーション
	 * @param message メッセージ
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAOImpl#findStatus(String[], Integer, Timestamp, Timestamp, Timestamp, Timestamp, String, String)
	 */
	public Collection ejbFindStatus(String facilityId[], Integer priority,
			Timestamp outputFromDate, Timestamp outputToDate,
			Timestamp generationFromDate, Timestamp generationToDate,
			String application, String message) throws FinderException {
		return null;
	}
	
	/**
	 * 指定した引数に一致し、重要度が最高 かつ 最終変更日時が最新のステータス情報を検索します。
	 * 
	 * @param facilityId ファシリティIDの配列
	 * @param outputFromDate 最終変更日時（開始）
	 * @param outputToDate 最終変更日時（終了）
	 * @param generationFromDate 出力日時（開始）
	 * @param generationToDate 出力日時（終了）
	 * @param application アプリケーション
	 * @param message メッセージ
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAOImpl#findHighPriorityStatus(String[], Timestamp, Timestamp, Timestamp, Timestamp, String, String)
	 */
	public Collection ejbFindHighPriorityStatus(String facilityId[],
			Timestamp outputFromDate, Timestamp outputToDate,
			Timestamp generationFromDate, Timestamp generationToDate,
			String application, String message) throws FinderException {
		return null;
	}
	
	/**
	 * 指定した存続期間日時を経過しているステータス情報を検索します。
	 * 
	 * @param expirationDate 存続期間日時
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.monitor.dao.StatusInfoDAOImpl#findExpirationStatus(Timestamp)
	 */
	public Collection ejbFindExpirationStatus(Timestamp expirationDate)
	throws FinderException {
		return null;
	}
	
	/**
	 * 監視項目IDを返します。
	 * 
	 * @return 監視項目ID
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 */
	public String getMonitorId() {
		return monitorId;
	}
	
	/**
	 * 監視項目IDを設定します。
	 * 
	 * @param monitorId 監視項目ID
	 * @ejb.interface-method
	 */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}
	
	/**
	 * プラグインIDを返します。
	 * 
	 * @return プラグインID
	 * @ejb.persistent-field 
	 * @ejb.pk-field
	 * @ejb.interface-method
	 */
	public String getPluginId() {
		return pluginId;
	}
	
	/**
	 * プラグインIDを設定します。
	 * 
	 * @param pluginId プラグインID
	 * @ejb.interface-method
	 */
	public void setPluginId(String pluginId) {
		this.pluginId = pluginId;
	}
	
	/**
	 * ファシリティIDを返します。
	 * 
	 * @return ファシリティID
	 * @ejb.persistent-field 
	 * @ejb.pk-field
	 * @ejb.interface-method
	 */
	public String getFacilityId() {
		return facilityId;
	}
	
	/**
	 * ファシリティIDを設定します。
	 * 
	 * @param facilityId ファシリティID
	 * @ejb.interface-method
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	
	/**
	 * アプリケーションを返します。
	 * 
	 * @return アプリケーション
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getApplication() {
		return application;
	}
	
	/**
	 * アプリケーションを設定します。
	 * 
	 * @param application アプリケーション
	 * @ejb.interface-method
	 */
	public void setApplication(String application) {
		this.application = application;
	}
	
	/**
	 * 存続期間日時を返します。
	 * 
	 * @return 存続期間日時
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getExpirationDate() {
		return expirationDate;
	}
	
	/**
	 * 存続期間日時を設定します。
	 * 
	 * @param expirationDate 存続期間日時
	 * @ejb.interface-method
	 */
	public void setExpirationDate(Timestamp expirationDate) {
		this.expirationDate = expirationDate;
	}
	
	/**
	 * 存続期間経過後の処理の制御フラグを返します。
	 * 
	 * @return the expirationFlg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public Integer getExpirationFlg() {
		return expirationFlg;
	}
	
	/**
	 * 存続期間経過後の処理の制御フラグを設定します。
	 * 
	 * @param expirationFlg 存続期間経過後の処理の制御フラグ
	 * @ejb.interface-method
	 * 
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public void setExpirationFlg(Integer expirationFlg) {
		this.expirationFlg = expirationFlg;
	}
	
	/**
	 * 出力日時を返します。
	 * 
	 * @return 出力日時
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getGenerationDate() {
		return generationDate;
	}
	
	/**
	 * 出力日時を設定します。
	 * 
	 * @param generationDate 出力日時
	 * @ejb.interface-method
	 */
	public void setGenerationDate(Timestamp generationDate) {
		this.generationDate = generationDate;
	}
	
	/**
	 * メッセージを返します。
	 * 
	 * @return メッセージ
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * メッセージを設定します。
	 * 
	 * @param message メッセージ
	 * @ejb.interface-method
	 */
	public void setMessage(String message) {
		this.message = message;
	}
	
	/**
	 * メッセージIDを返します。
	 * 
	 * @return メッセージID
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getMessageId() {
		return messageId;
	}
	
	/**
	 * メッセージIDを設定します。
	 * 
	 * @param messageId メッセージID
	 * @ejb.interface-method
	 */
	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}
	
	/**
	 * 最終変更日時を返します。
	 * 
	 * @return 最終変更日時
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Timestamp getOutputDate() {
		return outputDate;
	}
	
	/**
	 * 最終変更日時を設定します。
	 * 
	 * @param outputDate 最終変更日時
	 * @ejb.interface-method
	 */
	public void setOutputDate(Timestamp outputDate) {
		this.outputDate = outputDate;
	}
	
	/**
	 * 重要度を返します。
	 * 
	 * @return 重要度
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public Integer getPriority() {
		return priority;
	}
	
	/**
	 * 重要度を設定します。
	 * 
	 * @param priority 重要度
	 * @ejb.interface-method
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setPriority(Integer priority) {
		this.priority = priority;
	}
}
