/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.ejb.mdb;

import java.sql.Timestamp;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.monitor.factory.OutputEventLog;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.util.RunJob;
import com.clustercontrol.util.Messages;

/**
 * ジョブ実行を行う Message-Driven Bean です。
 * <p>ジョブ管理機能のジョブを呼出します。<BR>
 * ログ出力の遅延を発生させない様、非同期で処理を行うために、
 * Message-Driven Beanでジョブ呼出を実装します。
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="RunJobBean" 
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrol/Monitor/RunJob"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * 
 * @jboss.container-configuration
 *  name="Singleton Message Driven Bean"
 * 
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination jndi-name="queue/clustercontrol/Monitor/RunJob"
 * @jboss.destination-jndi-name name="queue/clustercontrol/Monitor/RunJob"
 *
 *--
 * <!-- end-xdoclet-definition -->
 **/
public class RunJobBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( RunJobBean.class );
	
	/** コンテキスト情報 */
	private javax.ejb.MessageDrivenContext messageContext = null;
	
	/**
	 * コンテキスト情報を設定します。<BR>
	 * Message-Driven Bean がインスタンスプールに格納される際に行う処理を実装します。
	 * @see javax.ejb.MessageDrivenBean#setMessageDrivenContext(javax.ejb.MessageDrivenContext)
	 */
	public void setMessageDrivenContext(
			javax.ejb.MessageDrivenContext messageContext)
	throws javax.ejb.EJBException {
		this.messageContext = messageContext;
	}
	
	/** 
	 * Message-Driven Bean が生成される際に行う処理を実装します。
	 * @ejb.create-method 
	 */
	public void ejbCreate() {
		//no specific action required for message-driven beans 
	}
	
	/** 
	 * Message-Driven Bean が削除される際に行う処理を実装します。
	 * @see javax.ejb.MessageDrivenBean#ejbRemove()
	 */
	public void ejbRemove() {
		messageContext = null;
	}
	
	/** 
	 * 引数で指定された受信メッセージを元に、ジョブ実行をおこないます。<BR>
	 * Message-Driven Bean で行うビジネスロジックを実装します。
	 * 特定のメッセージを受信した場合のみ処理を行います。受信メッセージは下記の通りです。
	 * 
	 * <p><li>{@link com.clustercontrol.monitor.message.LogOutputInfo} : 
	 * 含まれているログ出力情報を基にジョブを呼出します。
	 * ジョブの呼出に失敗した場合は、ログ出力情報の呼出失敗時の重要度で監視管理機能のイベントへ通知します。
	 *
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 * 
	 * @see com.clustercontrol.monitor.util.RunJob#run()
	 * @see com.clustercontrol.monitor.factory.OutputEventLog#insertEventLog(LogOutputInfo, int)
	 * @see com.clustercontrol.monitor.message.LogOutputInfo
	 */
	@SuppressWarnings("unchecked")
	public void onMessage(javax.jms.Message message) {
		m_log.debug("Message Driven Bean got message " + message);

		if(message instanceof ObjectMessage) {
			ObjectMessage msg = (ObjectMessage)message;
			
			try {
				Object objMsg = msg.getObject();
				if(objMsg instanceof LogOutputInfo) {
					try {
						RunJob job = new RunJob((LogOutputInfo)objMsg);
						job.run();
					} catch (Throwable e) {
						//ジョブ呼出失敗時、通知
						LogOutputInfo info = (LogOutputInfo)objMsg;
						LogOutputJobRunInfo jobRunInfo = info.getJobRun();
						//ジョブ失敗時の重要度を設定
						info.setPriority(jobRunInfo.getJobFailurePriority());
						info.setMessageId("");
			            String[] args1 = { jobRunInfo.getJobId() };
			            info.setMessage(Messages.getString("message.monitor.41", args1));
						info.setMessageOrg("");
						OutputEventLog eventLog = new OutputEventLog();
						Date now = new Date();
						eventLog.setOutputDate(new Timestamp(now.getTime()));
						try {
							eventLog.insertEventLog(info, YesNoConstant.TYPE_NO);
						} catch (NamingException e1) {
							//TODO NamingException 未実装
						} catch (CreateException e1) {
							//TODO CreateException 未実装
						}
					}
				}
				else {
					m_log.debug("onMessage(): ObjectMessage is not an expected instance. " + objMsg.toString());
				}
			}
			catch(JMSException e) {
				m_log.error("onMessage():" + e.getMessage());
			}
			catch(EJBException e) {
				m_log.error("onMessage():" + e.getMessage());
			}
			catch(Exception e) {
				m_log.error("onMessage():" + e.getMessage());
			}	
		}
	}
}