/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.util.ArrayList;
import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.message.LogOutputBasicInfo;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;

/**
 * ログ出力情報を作成するクラスです。
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class CreateLogOutputInfo {

	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( CreateLogOutputInfo.class );

    /**
	 * 引数で指定された情報を基に、ログ出力情報を作成し返します。
	 * 通知情報に通知方法（ステータス通知／イベント通知）が指定されていない場合は、 <code>null</code> を返します。
	 * 
	 * @param notifyInfo 通知情報
	 * @param basicInfo ログ出力基本情報
	 * @return ログ出力情報
	 */
	public LogOutputInfo get(NotifyInfo notifyInfo, LogOutputBasicInfo basicInfo) {
		
		// 通知情報に通知方法が指定されていない場合
		if(ValidConstant.TYPE_INVALID == notifyInfo.getStatusFlg() && 
				ValidConstant.TYPE_INVALID == notifyInfo.getEventFlg()){
			
			return null;
		}
		
		LogOutputInfo logOutputInfo = new LogOutputInfo();
		
		// ステータス通知
		if(notifyInfo.getStatusFlg() == ValidConstant.TYPE_VALID){
			
			logOutputInfo.setStatusInfoFlg(ValidConstant.typeToBoolean(notifyInfo.getStatusFlg()));
			if(notifyInfo.getStatusValidPeriod() != null)
				logOutputInfo.setStatusValidPeriod(notifyInfo.getStatusValidPeriod().intValue());
			if(notifyInfo.getStatusInvalidFlg() != null)
				logOutputInfo.setStatusInvalidFlg(notifyInfo.getStatusInvalidFlg().intValue());
			if(notifyInfo.getStatusUpdatePriority() != null)
				logOutputInfo.setStatusUpdatePriority(notifyInfo.getStatusUpdatePriority().intValue());
		}
		
		// イベント通知
		if(notifyInfo.getEventFlg() == ValidConstant.TYPE_VALID){
						
			// イベント通知情報を取得
			ArrayList<NotifyEventInfo> list = notifyInfo.getNotifyEventInfo();
			NotifyEventInfo event = null;
			
			if(list != null){
				NotifyEventInfo tmpEvent = null;
				for(int index=0; index<list.size(); index++){
					tmpEvent = (NotifyEventInfo)list.get(index);
					if(tmpEvent != null){
						if(tmpEvent.getPriority().intValue() == basicInfo.getPriority()){
							event = tmpEvent;
							break;
						}
					}
				}
				
				if(event != null){
					
					// 取得したイベントが「通知する」だった場合
					if(event.getEventNormalFlg() == ValidConstant.TYPE_VALID){
						
						logOutputInfo.setEventLogFlg(ValidConstant.typeToBoolean(notifyInfo.getEventFlg()));
						logOutputInfo.setConfirmFlg(event.getEventNormalState().intValue());
						
						// メール送信
						if(event.getMailFlg() == ValidConstant.TYPE_VALID){
							
							String address = event.getMailAddress();
							StringTokenizer t = new StringTokenizer(address, ";");
							ArrayList<String> addressList = new ArrayList<String>();
							while (t.hasMoreTokens()) {
								addressList.add(t.nextToken());
							}
							logOutputInfo.setAddress((String[]) addressList.toArray(new String[0]));
						}
						
						// イベント重複時の抑制
						if(event.getEventInhibitionFlg() == ValidConstant.TYPE_VALID){
							
							boolean isInhibition = false;
							
							// 期間 
							if(ExclusionConstant.TYPE_FREQUENCY == notifyInfo.getInhibitionFlg()){
								logOutputInfo.setExcludeNumber(notifyInfo.getInhibitionFrequency().intValue());
								isInhibition = true;
							}
							// 回数
							else if(ExclusionConstant.TYPE_PERIOD == notifyInfo.getInhibitionFlg()){
								logOutputInfo.setExcludePeriod(notifyInfo.getInhibitionPeriod().intValue());
								isInhibition = true;
							}
							// 重要度
							else if(ExclusionConstant.TYPE_PRIORITY == notifyInfo.getInhibitionFlg()){
								isInhibition = true;
							}
							
							// 抑制する場合
							if(isInhibition){
								logOutputInfo.setExcludeFlg(notifyInfo.getInhibitionFlg().intValue());
								logOutputInfo.setExcludeConfirmFlg(event.getEventInhibitionState().intValue());
							}
						}
					}
				}
			}
		}
		
		// ステータス または イベント通知する場合
		if(logOutputInfo.isStatusInfoFlg() || logOutputInfo.isEventLogFlg()){
			
			// ログ出力情報を設定
			logOutputInfo.setPluginId(basicInfo.getPluginId());
			logOutputInfo.setMonitorId(basicInfo.getMonitorId());
			logOutputInfo.setFacilityId(basicInfo.getFacilityId());
			logOutputInfo.setScopeText(basicInfo.getScopeText());
			logOutputInfo.setApplication(basicInfo.getApplication());
			logOutputInfo.setMessageId(basicInfo.getMessageId());
			logOutputInfo.setMessage(basicInfo.getMessage());
			logOutputInfo.setMessageOrg(basicInfo.getMessageOrg());
			logOutputInfo.setPriority(basicInfo.getPriority());
			logOutputInfo.setGenerationDate(basicInfo.getGenerationDate());
			logOutputInfo.setMultiId(basicInfo.getMultiId());
			
			logOutputInfo.setJobRun(basicInfo.getJobRun());
		}
		else{
			return null;
		}
		return logOutputInfo;
	}
}
