/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.message;

import com.clustercontrol.bean.EventConfirmConstant;
import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.StatusExpirationConstant;

/**
 * ログ出力情報を保持するクラスです。
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class LogOutputInfo extends LogOutputBasicInfo{
			
	private static final long serialVersionUID = -2842049557389840625L;
	
	private boolean m_eventLogFlg;		// イベント通知フラグ
	private boolean m_statusInfoFlg;		// ステータス通知フラグ

	/** @since 2.0.0 */
	private int m_statusValidPeriod = 0;	// ステータス有効期間（分）0以下は無期限
	/** @since 2.0.0 */
	private int m_statusInvalidFlg=StatusExpirationConstant.TYPE_DELETE;		// ステータス有効期間経過後の扱い
	/** @since 2.0.0 */
	private int m_statusUpdatePriority=StatusExpirationConstant.TYPE_WARNING;	// ステータス更新時重要度
	
	private int m_confirmFlg = EventConfirmConstant.TYPE_UNCONFIRMED;		// 通知時の状態（未確認/確認済）

	/** @since 2.0.0 */
	private int m_excludeConfirmFlg = EventConfirmConstant.TYPE_CONFIRMED;	// 抑制時の状態（確認済/破棄）
	
	/** @since 2.0.0 */
	private int m_excludeFlg = ExclusionConstant.TYPE_NO;	// 除外フラグ
	private int m_excludePeriod;			// 除外期間（分）
	private int m_excludeNumber;			// 除外回数
	private String[] m_address;			// 通知情報（送信先メールアドレス）
	
	/**
	 * メールアドレスを返します。
	 * 
	 * @return メールアドレス
	 */
	public String[] getAddress() {
		return m_address;
	}
	/**
	 * メールアドレスを設定します。
	 * 
	 * @param address メールアドレス
	 */
	public void setAddress(String[] address) {
		this.m_address = address;
	}
	/**
	 * 通知時の状態（未確認/確認済）を返します。
	 * 
	 * @return 通知時の状態（未確認/確認済）
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public int getConfirmFlg() {
		return m_confirmFlg;
	}
	/**
	 * 通知時の状態（未確認/確認済）を設定します。
	 * 
	 * @param flg 通知時の状態（未確認/確認済）
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public void setConfirmFlg(int flg) {
		m_confirmFlg = flg;
	}
	/**
	 * イベント通知フラグを返します。
	 * イベントを通知する場合に <code>true</code> を返します。
	 * 
	 * @return イベントを通知する場合は <code>true</code>
	 */
	public boolean isEventLogFlg() {
		return m_eventLogFlg;
	}
	/**
	 * イベント通知フラグを設定します。
	 * 
	 * @param logFlg イベントを通知する場合は <code>true</code>
	 */
	public void setEventLogFlg(boolean logFlg) {
		m_eventLogFlg = logFlg;
	}
	/**
	 * 抑制回数を返します。
	 * getExcludeFlgで、抑制回数と設定されている場合のみ有効となります。
	 * 
	 * @return 抑制回数
	 * @see #getExcludeFlg()
	 */
	public int getExcludeNumber() {
		return m_excludeNumber;
	}
	/**
	 * 抑制回数を設定します。
	 * getExcludeFlg()で、抑制回数と設定されている場合のみ有効となります。
	 * 
	 * @param number 抑制回数
	 * @see #getExcludeFlg()
	 */
	public void setExcludeNumber(int number) {
		m_excludeNumber = number;
	}
	/**
	 * 抑制期間を返します。
	 * getExcludeFlgで、抑制期間と設定されている場合のみ有効となります。
	 * 
	 * @return 抑制期間（分単位）
	 * @see #getExcludeFlg()
	 */
	public int getExcludePeriod() {
		return m_excludePeriod;
	}
	/**
	 * 抑制期間を設定します。
	 * getExcludeFlgで、抑制期間と設定されている場合のみ有効となります。
	 * 
	 * @param period 抑制期間（分単位）
	 * @see #getExcludeFlg()
	 */
	public void setExcludePeriod(int period) {
		m_excludePeriod = period;
	}
	/**
	 * ステータス通知フラグを返します。
	 * ステータスを通知する場合に <code>true</code> を返します。
	 * 
	 * @return ステータスを通知する場合は <code>true</code>
	 */
	public boolean isStatusInfoFlg() {
		return m_statusInfoFlg;
	}
	/**
	 * ステータス通知フラグを設定します。
	 * 
	 * @param infoFlg ステータスを通知する場合は <code>true</code>
	 */
	public void setStatusInfoFlg(boolean infoFlg) {
		m_statusInfoFlg = infoFlg;
	}
	/**
	 * 抑制時の状態（確認済/破棄）を返します。
	 * 
	 * @return 抑制時の状態（確認済/破棄）
	 * @since 2.0.0
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public int getExcludeConfirmFlg() {
		return m_excludeConfirmFlg;
	}
	/**
	 * 抑制時の状態（確認済/破棄）を設定します。
	 * 
	 * @param confirmFlg 抑制時の状態（確認済/破棄）
	 * @since 2.0.0
	 * @see com.clustercontrol.bean.EventConfirmConstant
	 */
	public void setExcludeConfirmFlg(int confirmFlg) {
		m_excludeConfirmFlg = confirmFlg;
	}
	/**
	 * 抑制タイプを返します。
	 * イベント重複時の通知回数の抑制（イベント・メール）での抑制タイプを返します。
	 * 
	 * @return 抑制タイプ
	 * @since 2.0.0
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public int getExcludeFlg() {
		return m_excludeFlg;
	}
	/**
	 * 抑制タイプを設定します。
	 * イベント重複時の通知回数の抑制（イベント・メール）での抑制タイプを設定します。
	 * 
	 * @param flg 抑制タイプ
	 * @since 2.0.0
	 * @see com.clustercontrol.bean.ExclusionConstant
	 */
	public void setExcludeFlg(int flg) {
		m_excludeFlg = flg;
	}
	/**
	 * ステータス情報の存続期間経過後の処理を返します。
	 * 
	 * @return ステータス情報の存続期間経過後の処理
	 * @since 2.0.0
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public int getStatusInvalidFlg() {
		return m_statusInvalidFlg;
	}
	/**
	 * ステータス情報の存続期間経過後の処理を設定します。
	 * 
	 * @param invalidFlg ステータス情報の存続期間経過後の処理
	 * @since 2.0.0
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 */
	public void setStatusInvalidFlg(int invalidFlg) {
		m_statusInvalidFlg = invalidFlg;
	}
	/**
	 * ステータス情報更新時の重要度を返します。
	 * getStatusInvalidFlgで、更新すると設定されている場合のみ有効となります。
	 * 
	 * @return ステータス情報更新時の重要度
	 * @since 2.0.0
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 * @see #getStatusInvalidFlg()
	 */
	public int getStatusUpdatePriority() {
		return m_statusUpdatePriority;
	}
	/**
	 * ステータス情報更新時の重要度を設定します。
	 * getStatusInvalidFlgで、更新すると設定されている場合のみ有効となります。
	 * 
	 * @param updatePriority ステータス情報更新時の重要度
	 * @since 2.0.0
	 * @see com.clustercontrol.bean.StatusExpirationConstant
	 * @see #getStatusInvalidFlg()
	 */
	public void setStatusUpdatePriority(int updatePriority) {
		m_statusUpdatePriority = updatePriority;
	}
	/**
	 * ステータス情報の存続期間を返します。
	 * 0以下は無期限です。
	 * 
	 * @return ステータス情報更新時の存続期間
	 * @since 2.0.0
	 */
	public int getStatusValidPeriod() {
		return m_statusValidPeriod;
	}
	/**
	 * ステータス情報の存続期間を設定します。
	 * 無期限の場合は、0以下を設定します。
	 * 
	 * @param validPeriod ステータス情報の存続期間
	 * @since 2.0.0
	 */
	public void setStatusValidPeriod(int validPeriod) {
		m_statusValidPeriod = validPeriod;
	}
}
