

-- 
-- TABLE: cc_notify_info 
--

CREATE TABLE cc_notify_info(
    notify_id               VARCHAR(64)     NOT NULL,
    description             VARCHAR(256),
    status_flg              SMALLINT        NOT NULL,
    status_valid_period     SMALLINT,
    status_invalid_flg      SMALLINT,
    status_update_priority  SMALLINT,
    event_flg               SMALLINT        NOT NULL,
    inhibition_flg          SMALLINT        NOT NULL,
    inhibition_frequency    SMALLINT,
    inhibition_period       SMALLINT,
    reg_date                TIMESTAMP,
    update_date             TIMESTAMP,
    CONSTRAINT p_key_cc_notify_info PRIMARY KEY (notify_id)
) 
;

-- 
-- TABLE: cc_notify_event_info 
--

CREATE TABLE cc_notify_event_info(
    notify_id               VARCHAR(64)     NOT NULL,
    priority                SMALLINT        NOT NULL,
    event_normal_flg        SMALLINT        NOT NULL,
    event_normal_state      SMALLINT        NOT NULL,
    event_inhibition_flg    SMALLINT        NOT NULL,
    event_inhibition_state  SMALLINT,
    mail_flg                SMALLINT        NOT NULL,
    mail_address            VARCHAR(1024),
    CONSTRAINT p_key_cc_notify_event_info PRIMARY KEY (notify_id, priority)
) 
;

-- 
-- TABLE: cc_system_notify_info 
--

CREATE TABLE cc_system_notify_info
(
  notify_id varchar(64) NOT NULL,
  description varchar(256),
  status_flg int2 NOT NULL,
  status_valid_period int2,
  status_invalid_flg int2,
  status_update_priority int2,
  event_flg int2 NOT NULL,
  inhibition_flg int2 NOT NULL,
  inhibition_frequency int2,
  inhibition_period int2,
  reg_date timestamp,
  update_date timestamp,
  CONSTRAINT p_key_cc_system_notify_info PRIMARY KEY (notify_id)
) 
;

-- 
-- TABLE: cc_system_notify_event_info 
--

CREATE TABLE cc_system_notify_event_info
(
  notify_id varchar(64) NOT NULL,
  priority int2 NOT NULL,
  event_normal_flg int2 NOT NULL,
  event_normal_state int2 NOT NULL,
  event_inhibition_flg int2 NOT NULL,
  event_inhibition_state int2,
  mail_flg int2 NOT NULL,
  mail_address varchar(1024),
  CONSTRAINT p_key_cc_system_notify_event_info PRIMARY KEY (notify_id, priority)
)
;

-- 
-- TABLE: cc_notify_event_info 
--

ALTER TABLE cc_notify_event_info ADD CONSTRAINT Refcc_notify_info1 
    FOREIGN KEY (notify_id)
    REFERENCES cc_notify_info(notify_id)
;

-- 
-- TABLE: cc_system_notify_event_info 
--

ALTER TABLE cc_system_notify_event_info ADD CONSTRAINT Refcc_system_notify_info1 
    FOREIGN KEY (notify_id)
    REFERENCES cc_system_notify_info(notify_id)
;

