/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * 複数の収集済み性能値のリスト（CollectedDataInfo型のリスト）をまとめて保持するクラスです。
 * ファシリティIDと収集項目の２つをキーとして、収集済み性能値のリストを取得することが出来ます。
 * @version 1.0
 * @since 1.0
 */
public class CollectedDataSet implements Serializable {
	private HashMap dataMap;
	
	/**
	 * コンストラクター
	 *
	 */
	public CollectedDataSet(){
		dataMap = new HashMap();
	}
	
	/**
	 * 指定のファシリティIDと収集項目IDをキーに収集済み性能値データのリストを登録します。
	 * 
 	 * @param facilityID ファシリティID　
	 * @param collectionItemID 収集項目ID
	 * @param data 性能値データのリスト
	 */
	public void setCollectedDataList(String facilityID, int collectionItemID, List data){
		HashMap subDataMap = (HashMap)dataMap.get(facilityID);
		
		if(subDataMap == null){
			// このファシリティIDのデータは初めての登録であるため新規作成
			subDataMap = new HashMap();
		}
		subDataMap.put(Integer.toString(collectionItemID), data);
		
		dataMap.put(facilityID, subDataMap);
	}
	
	/**
	 * 現在の性能値データのセットに、
	 * 指定のCollectedDataSetの収集済み性能値データを追加します。
	 * 同じ facilityID, collectionItemId のデータある場合は上書きされます。
	 * 
 	 * @param dataSet 追加する性能値データ
	 */
	public void addCollectedDataList(CollectedDataSet dataSet){
		Set facilityIDSet = dataSet.dataMap.keySet();
		Iterator fItr = facilityIDSet.iterator();
		
		while(fItr.hasNext()){
			String facilityID = (String)fItr.next();

			HashMap subDataMap = (HashMap)dataSet.dataMap.get(facilityID);
			Set itemIDSet = subDataMap.keySet();		
			Iterator iItr = itemIDSet.iterator();			
			
			while(iItr.hasNext()){
				String collectionItemID = (String)iItr.next();
				
				// 移し替えもとのデータを取得する
				List dataList = dataSet.getCollectedDataList(facilityID, Integer.parseInt(collectionItemID));
				
				// データをセットする
				setCollectedDataList(facilityID, Integer.parseInt(collectionItemID), dataList);
			}
		}
	}
	
	/**
	 * 指定のファシリティIDと収集項目IDをキーに収集済み性能値情報のリストを取得します。
	 * 
	 * @param facilityID ファシリティID
	 * @param collectionItemID 収集項目ID
	 * @return 性能値データのリスト
	 */
	public List getCollectedDataList(String facilityID, int collectionItemID){
		HashMap subDataMap = (HashMap)dataMap.get(facilityID);
		if(subDataMap != null){
			return (List)subDataMap.get(Integer.toString(collectionItemID));
		} else {
			// 空のリストを生成して返す
			return new ArrayList();
		}
	}
	
	/**
	 * 指定のファシリティIDで登録されている収集済みデータリストの数を取得します。
	 * 
	 * @param facilityID ファシリティID
	 * @return 指定のファシリティIDで登録されている収集済みデータリストの数
	 */
	public int getDataListNum(String facilityID){
		HashMap subDataMap = (HashMap)dataMap.get(facilityID);
		if(subDataMap != null){
			return subDataMap.size();
		} else {
			return 0;
		}
	}
}
