/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.bean;

import java.io.Serializable;

/**
 * 監視対象ノードのデバイス情報を扱うためのDTOクラス <p>
 * 
 * 私たちはデバイスの情報が運用中に変わる（Diskが追加されるなど）を
 * 想定していています。このクラスはデバイスの情報について収集の設定が
 * された際のスナップショットをDBへ保存するまたは、DBから読み出した内容を
 * 保持するクラスです。
 * 主な目的は収集を行っている時点での取得状態をプロパティで再現することを目的として
 * としています。
 * 
 * @version 1.0
 * @since 1.0
 */
public class DeviceData implements Serializable {
	private String facilityId;
	private String Oid;
	private int    deviceIndex;
	private String deviceName;
	private String deviceType;
	
	/**
	 * コンストラクター
	 * @param facilityID   ファシリティID
	 * @param oid　SNMPのオブジェクトID
	 * @param deviceIndex　デバイスのインデックス
	 * @param deviceName　デバイス名称
	 */
	public DeviceData(String facilityID, String oid, int deviceIndex, String deviceName, String deviceType) {
		super();
		this.facilityId = facilityID;
		Oid = oid;
		this.deviceIndex = deviceIndex;
		this.deviceName = deviceName;
		this.deviceType = deviceType;
	}
	/**
	 * コンストラクター
	 */
	public DeviceData() {
		facilityId = null;
		Oid		   = null;
		deviceIndex= 0;
		deviceName = null;
	}
	
	/**
	 * デバイスのインデックスを取得します。
	 * @return deviceIndex デバイスのインデックス
	 */
	public int getDeviceIndex() {
		return deviceIndex;
	}
	/**
	 * デバイスのインデックスを設定します。
	 * @param deviceIndex デバイスのインデックス
	 */
	public void setDeviceIndex(int deviceIndex) {
		this.deviceIndex = deviceIndex;
	}
	/**
	 * デバイス名称を取得します。
	 * @return deviceName デバイスのインデックス
	 */
	public String getDeviceName() {
		return deviceName;
	}
	/**
	 * デバイス名称を設定します。
	 * @param deviceName デバイス名称
	 */
	public void setDeviceName(String deviceName) {
		this.deviceName = deviceName;
	}
	/**
	 * ファシリティIDを戻します。
	 * @return facilityID を戻します。
	 */
	public String getFacilityId() {
		return facilityId;
	}
	/**
	 * ファシリティIDを設定します。
	 * @param facilityID ファシリティID
	 */
	public void setFacilityId(String facilityID) {
		this.facilityId = facilityID;
	}
	/**
	 * OIDを取得します。
	 * @return　oid SNMPのオブジェクトID
	 */
	public String getOid() {
		return Oid;
	}
	/**
	 * OIDを設定します。
	 * @param oid SNMPのオブジェクトID
	 */
	public void setOid(String oid) {
		this.Oid = oid;
	}
	/**
	 * デバイスのタイプを取得します。
	 * @return deviceType デバイスのタイプ
	 */
	public String getDeviceType() {
		return deviceType;
	}
	/**
	 * デバイスのタイプを設定します。
	 * @param deviceType デバイスのタイプ
	 */
	public void setDeviceType(String deviceType) {
		this.deviceType = deviceType;
	}
}
