/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.util.code;

import java.io.Serializable;


/**
 * 収集項目コードの情報を保持するクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemCodeInfo implements ICollectorItemInfo, Serializable {
    private String itemCode;
	private String categoryCode;
	private String parentCode;
	private String category;
    private String itemName;
    private String measure;
    private boolean deviceFlag;
    private String deviceType;
    private boolean rangeFixed;

    public CollectorItemCodeInfo(
    		String itemCode,
    		String categoryCode,
    		String parentCode,
    		String category,
    		String itemName,
            String measure,
            boolean deviceFlag,
            String deviceType,
            boolean rangeFixed) {
        this.itemCode = itemCode;
        this.categoryCode = categoryCode;
        this.parentCode = parentCode;
        this.category = category;
        this.itemName = itemName;
        this.measure = measure;
        this.deviceFlag = deviceFlag;
        this.deviceType = deviceType;
        this.rangeFixed = rangeFixed;
    }

    /**
     * @return deviceFlag を戻します。
     */
    public boolean isDeviceFlag() {
        return deviceFlag;
    }

    /**
     * @param deviceFlag
     *            deviceFlag を設定。
     */
    public void setDeviceFlag(boolean deviceFlag) {
        this.deviceFlag = deviceFlag;
    }

    /**
     * @return itemCode を戻します。
     */
    public String getItemCode() {
        return itemCode;
    }

    /**
     * @param itemCode
     *            itemCode を設定。
     */
    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    /**
     * @return itemName を戻します。
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * @param itemName
     *            itemName を設定。
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * @return measure を戻します。
     */
    public String getMeasure() {
        return measure;
    }

    /**
     * @param measure
     *            measure を設定。
     */
    public void setMeasure(String measure) {
        this.measure = measure;
    }

    /**
     * @return rangeFixed を戻します。
     */
    public boolean isRangeFixed() {
        return rangeFixed;
    }

    /**
     * @param rangeFixed
     *            rangeFixed を設定。
     */
    public void setRangeFixed(boolean rangeFixed) {
        this.rangeFixed = rangeFixed;
    }

	public String getName() {
		return getItemName();
	}

	public String getCode() {
		return getItemCode();
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getCategoryCode() {
		return categoryCode;
	}

	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}

	public String getDeviceType() {
		return deviceType;
	}

	public void setDeviceType(String deviceType) {
		this.deviceType = deviceType;
	}

	public String getParentCode() {
		return parentCode;
	}

	public void setParentCode(String parentCode) {
		this.parentCode = parentCode;
	}
}