/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performanceMGR.util.code;

import java.io.Serializable;
import java.util.ArrayList;

import com.clustercontrol.performanceMGR.bean.DeviceData;

/**
 * 収集項目の親子関係を保持するユーティリティクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemTreeItem  implements Serializable {
    /** カテゴリ */
    private CollectorItemCategoryInfo category = null;

    /** 親 */
    private CollectorItemTreeItem parent = null;

    /** 情報オブジェクト */
    private ICollectorItemInfo data = null;

    /** 子の格納リスト */
    private ArrayList<CollectorItemTreeItem> childrens = null;
    
    /** デバイス情報 */
    private DeviceData deviceData = null;

    public CollectorItemTreeItem(
    		CollectorItemTreeItem parent, 
    		ICollectorItemInfo data,
    		DeviceData deviceData) {
    	// デバイス情報を生成
       	this.deviceData = deviceData;
       		
    	// 要素が収集項目カテゴリの場合は、自分自身のカテゴリを設定する。
    	if (data instanceof CollectorItemCategoryInfo){
            this.setCategory((CollectorItemCategoryInfo)data);
        } else
        // 要素が収集項目コードの場合は、親のカテゴリと同じカテゴリとする。
        if (data instanceof CollectorItemCodeInfo) {
            this.setCategory(parent.getCategory());
            this.category.addItem((CollectorItemCodeInfo)data);
        }

        this.setParent(parent);  // 親を設定
        this.setData(data);  // 情報オブジェクトを設定

        if (parent != null) {
            parent.addChildren(this);
        }

        this.childrens = new ArrayList<CollectorItemTreeItem>();
    }
    
    /**
     * 親を設定します。
     * <p>
     * 
     * @return 親
     */
    private void setParent(CollectorItemTreeItem parent) {
        this.parent = parent;
    }

    /**
     * 子を追加します。
     * <p>
     * 
     * この際、childeの親はこのオブジェクトとして設定されます。
     * 
     * @param child
     *            子
     */
    private void addChildren(CollectorItemTreeItem child) {
        child.setParent(this);
        childrens.add(child);
    }

    /**
     * 収集項目コードを取得します。
     * 
     * @return itemCode 収集項目コード
     */
    public String getItemCode() {
    	if(data instanceof CollectorItemCodeInfo){
            return ((CollectorItemCodeInfo)data).getItemCode();
    	} else {
    		return null;
    	}
    }

    /**
     * 収集項目名を取得します。
     * 
     * @return 収集項目名
     */
    public String getItemName() {
    	if(data instanceof CollectorItemCodeInfo){
            return ((CollectorItemCodeInfo)data).getItemName();
    	} else {
    		return null;
    	}
    }

    /**
     * 詳細情報表示可能か否か（子項目があるか否か）を取得します。
     */
    public boolean hasBreakdown() {
        return (childrens.size() != 0);
    }

    /**
     * deviceFlag を取得します。
     * 
     * @return deviceFlag
     */
    public boolean isDeviceFlag() {
    	if(data instanceof CollectorItemCodeInfo){
            return ((CollectorItemCodeInfo)data).isDeviceFlag();
    	} else {
    		return false;
    	}
    }

    /**
     * デバイス種別を取得します。
     * 
     * @return deviceType
     */
    public String getDeviceType() {
        return ((CollectorItemCodeInfo)data).getDeviceType();
    }
    
    /**
     * isRangeFixed を取得します。
     * 
     * @return isRangeFixed
     */
    public boolean isRangeFixed() {
    	if(data instanceof CollectorItemCodeInfo){
            return ((CollectorItemCodeInfo)data).isRangeFixed();
    	} else {
    		return false;
    	}
    }

    /**
     * measure を取得します。
     * 
     * @return measure
     */
    public String getMeasure() {
    	if(data instanceof CollectorItemCodeInfo){
            return ((CollectorItemCodeInfo)data).getMeasure();
    	} else{
    		return null;
    	}
    }

    /**
     * category を取得します。
     * 
     * @return category
     */
    public CollectorItemCategoryInfo getCategory() {
        return category;
    }

    /**
     * category を設定します。
     * 
     * @param category
     */
    private void setCategory(CollectorItemCategoryInfo category) {
        this.category = category;
    }

    /**
     * childrens を取得します。
     * 
     * @return childrens
     */
    public ArrayList getChildrens() {
        return childrens;
    }

    /**
     * childrens を設定します。
     * 
     * @param childrens
     */
//    private void setChildrens(ArrayList childrens) {
//        this.childrens = childrens;
//    }

    /**
     * data を取得します。
     * 
     * @return data
     */
    public ICollectorItemInfo getData() {
        return data;
    }

    /**
     * data を設定します。
     * 
     * @param data
     */
    private void setData(ICollectorItemInfo data) {
        this.data = data;
    }

    /**
     * parent を取得します。
     * 
     * @return parent
     */
    public CollectorItemTreeItem getParent() {
        return parent;
    }
    
    
    
    
    
    
    
    
    
    
	public int size() {
		return childrens.size();
	}
	
	public DeviceData getDeviceData(){
		return deviceData;
	}
}