/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.composite.action.FacilityTreeSelectionChangedListener;
import com.clustercontrol.repository.composite.action.ScopeListSelectionChangedListener;
import com.clustercontrol.repository.view.action.NodeAssignAction;
import com.clustercontrol.repository.view.action.NodeReleaseAction;
import com.clustercontrol.repository.view.action.ScopeAddAction;
import com.clustercontrol.repository.view.action.ScopeDeleteAction;
import com.clustercontrol.repository.view.action.ScopeModifyAction;
import com.clustercontrol.view.ScopeListBaseView;

/**
 * スコープ登録ビュークラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeListView extends ScopeListBaseView {
    public static final String ID = "com.clustercontrol.repository.view.ScopeListView";

    // ----- instance フィールド ----- //

    /** リポジトリ[スコープ]ビュー用コンポジット */
    protected ScopeListComposite composite = null;

    // ----- コンストラクタ ----- //

    // ----- instance メソッド ----- //

    /**
     * @see com.clustercontrol.view.ScopeListBaseView#createListContents(org.eclipse.swt.widgets.Composite)
     */
    protected Composite createListContents(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.composite = new ScopeListComposite(parent, SWT.NONE);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.composite.setLayoutData(gridData);
        
        //ポップアップメニュー作成
        createContextMenu();
        
        //Listenerの追加
        super.getScopeTreeComposite().getTreeViewer().addSelectionChangedListener(
        		new FacilityTreeSelectionChangedListener());
        
        this.composite.getTableViewer().addSelectionChangedListener(
        		new ScopeListSelectionChangedListener(composite));
        

        this.update();

        return this.composite;
    }
    
    /**
     * ポップアップメニュー作成
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //メニュー項目設定
                fillContextMenu(manager);
            }
        });
        
        Menu treeMenu = menuManager.createContextMenu(this.getScopeTreeComposite().getTree());
        this.getScopeTreeComposite().getTree().setMenu(treeMenu);

        Menu listMenu = menuManager.createContextMenu(this.composite.getTable());
        this.composite.getTable().setMenu(listMenu);
    }

    /**
     * メニュー項目追加
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ビューのアクションのインスタンスを取得
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem scopeAddAction = (ActionContributionItem) toolbar
                .find(ScopeAddAction.ID);
        ActionContributionItem scopeModifyAction = (ActionContributionItem) toolbar
                .find(ScopeModifyAction.ID);
        ActionContributionItem scopeDeleteAction = (ActionContributionItem) toolbar
        		.find(ScopeDeleteAction.ID);
        ActionContributionItem nodeAssignAction = (ActionContributionItem) toolbar
        		.find(NodeAssignAction.ID);
        ActionContributionItem nodeReleaseAction = (ActionContributionItem) toolbar
        		.find(NodeReleaseAction.ID);

        //ポップアップメニューにアクションを追加
        manager.add(scopeAddAction.getAction());
        manager.add(scopeModifyAction.getAction());
        manager.add(scopeDeleteAction.getAction());
        manager.add(nodeAssignAction.getAction());
        manager.add(nodeReleaseAction.getAction());
    }


    /**
     * 選択されたスコープ(ノード)の情報を表示します。
     * 
     * @param item
     *            ツリーアイテム
     */
    protected void doSelectTreeItem(FacilityTreeItem item) {
        this.composite.update(item);
    }

    /**
     * ビューを更新します。
     * 
     * @see com.clustercontrol.view.AutoUpdateView#update()
     */
    public void update() {
        FacilityTreeItem item = this.getScopeTreeComposite().getSelectItem();
        this.composite.update(item);
    }

    /**
     * アダプターとして要求された場合、自身のインスタンスを渡します。
     * 
     * @param cls
     *            クラスのインスタンス
     * @return 自身のインスタンス
     */
    public Object getAdapter(Class cls) {
        if (cls.isInstance(this)) {
            return this;
        } else {
            return super.getAdapter(cls);
        }
    }
    
    /**
     * ビューのアクションの有効/無効を設定します。
     * 
     * @param type スコープとノードの種別
     * @param selection ボタン（アクション）を有効にするための情報
     * 
     * @see com.clustercontrol.bean.FacilityConstant
     */
    public void setEnabledAction(int type, ISelection selection) {
        if(this.getScopeTreeComposite().getTree().isFocusControl() || 
        		this.composite.getTable().isFocusControl()){
    		super.setEnabledAction(ScopeAddAction.ID, selection);
        	super.setEnabledAction(ScopeModifyAction.ID, selection);
        	super.setEnabledAction(ScopeDeleteAction.ID, selection);
        	super.setEnabledAction(NodeAssignAction.ID, selection);
        	super.setEnabledAction(NodeReleaseAction.ID, selection);
        	
        	//ビューアクションの使用可/不可を設定
        	if (type == FacilityConstant.TYPE_COMPOSITE) {
        		super.setEnabledAction(ScopeAddAction.ID, true);
            	super.setEnabledAction(ScopeModifyAction.ID, false);
            	super.setEnabledAction(ScopeDeleteAction.ID, false);
            	super.setEnabledAction(NodeAssignAction.ID, false);
            	super.setEnabledAction(NodeReleaseAction.ID, false);
        		
        	} else if (type == FacilityConstant.TYPE_SCOPE) { 		
        		super.setEnabledAction(ScopeAddAction.ID, true);
            	super.setEnabledAction(ScopeModifyAction.ID, true);
            	super.setEnabledAction(ScopeDeleteAction.ID, true);
            	super.setEnabledAction(NodeAssignAction.ID, true);
            	super.setEnabledAction(NodeReleaseAction.ID, true);
            	
        	} else if (type == FacilityConstant.TYPE_NODE) {    		
        		super.setEnabledAction(ScopeAddAction.ID, false);
            	super.setEnabledAction(ScopeModifyAction.ID, false);
            	super.setEnabledAction(ScopeDeleteAction.ID, false);
            	super.setEnabledAction(NodeAssignAction.ID, false);
            	super.setEnabledAction(NodeReleaseAction.ID, false);
            	
        	}
        }
    }
}