/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.action.AssignNode;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.dialog.NodeAssignDialog;
import com.clustercontrol.repository.view.ScopeListView;
import com.clustercontrol.util.Messages;

/**
 * ノード選択ダイアログによる、ノードのスコープ割り当て処理を行うアクションクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeAssignAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.repository.view.action.NodeAllocateAction";

    //	 ----- instance フィールド ----- //

    private IViewPart viewPart; // ビュー

    // ----- instance メソッド ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // スコープ一覧より、選択されているアイテムを取得
        // スコープツリーより、選択されているスコープを取得
        ScopeListView view = (ScopeListView) this.viewPart
                .getAdapter(ScopeListView.class);

        FacilityTreeComposite tree = view.getScopeTreeComposite();
        ScopeListComposite list = (ScopeListComposite)view.getListComposite();
        
        FacilityTreeItem item = null;
        if(tree.getTree().isFocusControl()){
			item = tree.getSelectItem();
        }
        else if(list.getTableViewer().getTable().isFocusControl()){
        	item = list.getSelectItem();
        }
        else{
        	return;
        }

        // 未選択の場合は、処理終了
        if (item == null) {
            return;
        }
        // スコープ以外を選択している場合は、処理終了
        FacilityInfo info = item.getData();
        if (info.getType() != FacilityConstant.TYPE_SCOPE) {
            return;
        }

        // ダイアログを生成
        String facilityId = info.getFacilityId();
        NodeAssignDialog dialog = new NodeAssignDialog(this.viewPart.getSite()
                .getShell(), facilityId);

        // ダイアログにて変更が選択された場合、入力内容をもって登録を行う。
        if (dialog.open() == IDialogConstants.OK_ID) {
            String[] items = dialog.getFilterItems();

            if (new AssignNode().assign(facilityId, items)) {
                // 成功報告ダイアログを生成
            	MessageDialog.openInformation(
            			null, 
            			Messages.getString("successful"), 
            			Messages.getString("message.repository.6"));
            } else {
                // 失敗報告ダイアログを生成
            	MessageDialog.openError(
            			null, 
            			Messages.getString("failed"), 
            			Messages.getString("message.repository.7"));
            }

            tree.update();
            view.update();
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}