/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.repository.action.DeleteNodeProperty;
import com.clustercontrol.repository.bean.NodeListTabelDefine;
import com.clustercontrol.repository.view.NodeListView;
import com.clustercontrol.util.Messages;

/**
 * ノードの削除を行うアクションクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeDeleteAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.repository.view.action.NodeDeleteAction";

    //	 ----- instance フィールド ----- //

    private IViewPart viewPart; // ビュー

    // ----- instance メソッド ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // ノード一覧より、選択されているノードのファシリティIDを取得

        NodeListView view = (NodeListView) this.viewPart
                .getAdapter(NodeListView.class);

        StructuredSelection selection = (StructuredSelection) view
                .getComposite().getTableViewer().getSelection();

        List list = (List) selection.getFirstElement();
        String facilityId = null;
        String facilityName = null;
        if (list != null) {
            facilityId = (String) list.get(NodeListTabelDefine.FACILITY_ID);
            facilityName = (String) list.get(NodeListTabelDefine.FACILITY_NAME);
        }

        if (facilityId != null) {
            // 確認ダイアログにて変更が選択された場合、削除処理を行う。
            String[] args = { facilityName, facilityId };
            if (MessageDialog.openConfirm(
        			null, 
        			Messages.getString("confirmed"), 
        			Messages.getString("message.repository.1", args))) {

                if (new DeleteNodeProperty().delete(facilityId)) {
                    // 成功報告ダイアログを生成
                	MessageDialog.openInformation(
                			null, 
                			Messages.getString("successful"), 
                			Messages.getString("message.repository.8"));
                } else {
                    // 失敗報告ダイアログを生成
                	MessageDialog.openError(
                			null, 
                			Messages.getString("failed"), 
                			Messages.getString("message.repository.9"));
                }

                // ビューを更新
                view.update();
            }
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}