/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.repository.dao.FacilityTreeDAOImpl;

/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>FacilityTreeBean</b></em>'. <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="FacilityTree"
 *	jndi-name="FacilityTree"
 *	type="BMP"
 * 
 * @ejb.dao class="com.clustercontrol.repository.dao.FacilityTreeDAO"
 * impl-class="com.clustercontrol.repository.dao.FacilityTreeDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * <!-- end-xdoclet-defintion -->
 * @generated
 **/
public abstract class FacilityTreeBean implements javax.ejb.EntityBean {
	public String dn;
	public String facilityId;
	public Integer treeType;
	public String  parentFacilityId;
	
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the parentFacilityId.
	 */
	public String getParentFacilityId() {
		return parentFacilityId;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param parentFacilityId The parentFacilityId to set.
	 */
	public void setParentFacilityId(String parentFacilityId) {
		this.parentFacilityId = parentFacilityId;
	}
	/**
	 * @ejb.persistence
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return Returns the dn.
	 */
	public String getDn() {
		return dn;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param dn The dn to set.
	 */
	public void setDn(String dn) {
		this.dn = dn;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the facilityId.
	 */
	public String getFacilityId() {
		return facilityId;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param facilityId The facilityId to set.
	 */
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	/**
	 * @ejb.persistence
	 * @ejb.interface-method
	 * 
	 * @return Returns the treeType.
	 */
	public Integer getTreeType() {
		return treeType;
	}
	/**
	 * @ejb.interface-method
	 * 
	 * @param treeType The treeType to set.
	 */
	public void setTreeType(Integer treeType) {
		this.treeType = treeType;
	}
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public FacilityTreePK ejbCreate(String facilityId, int treeType, String parentFacilityId) throws javax.ejb.CreateException {
		setFacilityId(facilityId);
		setTreeType(new Integer(treeType));
		setParentFacilityId(parentFacilityId);
		return null;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {

	}
	
	public Collection ejbFindAll() throws FinderException{ 
		return null; 
	}
	
	public Collection ejbFindAll(String facilityId) throws FinderException{ 
		return null; 
	}
	
	public Collection ejbFindAllNode(String facilityId) throws FinderException{ 
		return null; 
	}
	
	public Collection ejbFindAllScope(String facilityId) throws FinderException{ 
		return null; 
	}
	
	public Collection ejbFindOneLevel() throws FinderException{ 
		return null; 
	}
	
	public Collection ejbFindOneLevel(String facilityId) throws FinderException{ 
		return null; 
	}
	
	public Collection ejbFindOneLevelNode(String facilityId) throws FinderException{ 
		return null; 
	}
	
	public Collection ejbFindOneLevelScope(String facilityId) throws FinderException{ 
		return null; 
	}
	
	public FacilityTreePK ejbFindByPrimaryKey(FacilityTreePK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindChildren(FacilityTreePK pk) throws FinderException{ 
		return null; 
	}

	public Collection ejbFindByFacilityId(String facilityId) throws FinderException {
		return null;
	}
	
	/**
	 * @ejb.interface-method
	 *  view-type="local"
	 * 
	 * @generated
	 */
	public FacilityTreeLocal getParent() throws FinderException{
		String parentDn = getDn();
		parentDn = parentDn.replaceFirst("[\\s\\S\\w\\W=&&[^,]]*,", "");
		if(parentDn.compareTo(getDn()) == 0 || 
		        parentDn.compareTo(FacilityTreeDAOImpl.BASE_DN) == 0){
			return null;
		}
		FacilityTreePK pk = new FacilityTreePK(parentDn);
		FacilityTreeLocal unit = null;
		try {
			unit = FacilityTreeUtil.getLocalHome().findByPrimaryKey(pk);
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
		}
		return unit;
	}

	/**
	 * @ejb.interface-method
	 *  view-type="local"
	 * 
	 * @generated
	 */
	public Collection getChildren() throws FinderException { 
		FacilityTreePK pk = new FacilityTreePK(getDn());
		Collection collection = null;
		try {
			collection = FacilityTreeUtil.getLocalHome().findChildren(pk);
		} catch (FinderException e) {
			//TODO FinderException未実装
		} catch (NamingException e) {
			//TODO NaimingException未実装
		}
		return collection;
	}
	
	/**
	 * @ejb.interface-method
	 *  view-type="local"
	 * 
	 * @generated
	 */
	public FacilityLocal getFacility() throws FinderException { 
		FacilityLocal facility = null;
		try {
			facility = FacilityUtil.getLocalHome().findByFacilityId(getFacilityId());
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			//TODO NaimingException未実装
		}
		return facility;
	}
}
