/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.commons.ejb.UsedFacilityException;
import com.clustercontrol.repository.bean.NodeListTabelDefine;
import com.clustercontrol.repository.bean.NodeScopeTabelDefine;
import com.clustercontrol.repository.bean.ScopeListTableDefine;
import com.clustercontrol.repository.factory.DeleteFacility;
import com.clustercontrol.repository.factory.ModifyFacility;
import com.clustercontrol.repository.factory.NodeFilterProperty;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.repository.factory.ScopeProperty;
import com.clustercontrol.repository.factory.SelectFacility;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="RepositoryController"	
 *           jndi-name="RepositoryController"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *           
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class RepositoryControllerBean implements javax.ejb.SessionBean {
	protected static Log m_log = LogFactory.getLog( RepositoryControllerBean.class ); 
	
	private SessionContext m_context;
	
	public static final int ALL = 0;
	public static final int ONE_LEVEL = 1;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}

	/**
	 * ファシリティツリー取得(ノード含む)
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param locale
	 * @return FacilityTreeItemの階層オブジェクト
	 * @throws FinderException
	 * @throws NamingException
	 */
	public FacilityTreeItem getFacilityTree(Locale locale) throws FinderException, NamingException {

		//ファシリティツリー(ノード含む)を取得
		FacilityTreeItem item = null;
		try {
			SelectFacility select = new SelectFacility();
			item = select.getFacilityTree(locale);
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getFacilityTree() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}

		return item;
	}
	
	/**
	 * ファシリティツリー取得(スコープのみ)
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param locale
	 * @return FacilityTreeItemの階層オブジェクト
	 * @throws NamingException
	 * @throws FinderException
	 */
	public FacilityTreeItem getScopeFacilityTree(Locale locale) throws FinderException, NamingException {
		
		FacilityTreeItem item = null;
		try {
			//ファシリティツリー(スコープのみ)を取得
			SelectFacility select = new SelectFacility();
			item = select.getScopeFacilityTree(locale);
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getScopeFacilityTree() -> " + e.getMessage());
		} catch (NamingException e) {
			throw e;
		}

		return item;
	}
	
	/**
	 * ノード一覧テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param locale
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getNodeListTableDefine(Locale locale) {
		
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(NodeListTabelDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.FACILITY_ID, 100, SWT.LEFT));
		tableDefine.add(NodeListTabelDefine.FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("facility.name", locale), TableColumnInfo.FACILITY_NAME, 150, SWT.LEFT));
		tableDefine.add(NodeListTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 200, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * 割当スコープ一覧テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param locale
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getNodeScopeTableDefine(Locale locale) {
		
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(NodeScopeTabelDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.NONE, 300, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * 割当スコープ一覧取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @return オブジェクトの2次元配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeScopeList(String facilityId) throws FinderException, NamingException {
		
		try {
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getNodeScopeList(facilityId);
			
			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getNodeScopeList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * スコープ一覧テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param locale
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getScopeListTableDefine(Locale locale) {
		
		/** テーブル情報定義配列 */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(ScopeListTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.FACILITY_ID, 100, SWT.LEFT));
		tableDefine.add(ScopeListTableDefine.FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("facility.name", locale), TableColumnInfo.FACILITY_NAME, 150, SWT.LEFT));
		tableDefine.add(ScopeListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 200, SWT.LEFT));

		return tableDefine;
	}
	

	/**
	 * スコープ一覧取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @return オブジェクトの2次元配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getScopeList(String parentFacilityId) throws FinderException, NamingException {
		
		try {
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getScopeList(parentFacilityId);
			
			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getScopeList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ノード一覧取得
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @return オブジェクトの2次元配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList() throws FinderException, NamingException {
	
		try {
			//ファシリティツリーを取得
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getNodeList();

			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getNodeList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ノード一覧取得
	 * 
	 * ファシリティIDの配下または直下のノード一覧を取得する
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return オブジェクトの2次元配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeList(String parentFacilityId, int level) throws FinderException, NamingException {
		
		try {
			//ファシリティツリーを取得
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getNodeList(parentFacilityId, level);
			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getNodeList() -> " + e.getMessage()); 
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ノード一覧取得
	 * 
	 * Propertyの検索条件に該当するノード一覧を取得する
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @return オブジェクトの2次元配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList(Property property) throws FinderException, NamingException {
		
		try {
			//ファシリティツリーを取得
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getNodeList(property);
			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getNodeList() -> " + e.getMessage()); 
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return ファシリティIDの配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getFacilityIdList(String parentFacilityId, int level) throws FinderException, NamingException {
		
		try {
			//ファシリティツリーを取得
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getFacilityIdList(parentFacilityId, level, false);
			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getFacilityIdList() -> " + e.getMessage()); 
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @param sort
	 * @return ファシリティIDの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
		
		try {
			//ファシリティツリーを取得
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getFacilityIdList(parentFacilityId, level, sort);
			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getFacilityIdList() -> " + e.getMessage()); 
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return ファシリティIDの配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeFacilityIdList(String parentFacilityId, int level) throws FinderException, NamingException {
		
		try {
			//ファシリティツリーを取得
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getNodeFacilityIdList(parentFacilityId, level, false);
			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getNodeFacilityIdList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @param sort
	 * @return ファシリティIDの配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
		
		try {
			//ファシリティツリーを取得
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getNodeFacilityIdList(parentFacilityId, level, sort);
			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getNodeFacilityIdList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @return ファシリティIDの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeFacilityIdList() throws FinderException, NamingException {
		
		try {
			//ファシリティツリーを取得
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getNodeFacilityIdList(false);
			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getNodeFacilityIdList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param sort
	 * @return ファシリティIDの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeFacilityIdList(boolean sort) throws FinderException, NamingException {
		
		try {
			//ファシリティツリーを取得
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getNodeFacilityIdList(sort);
			return list;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getNodeFacilityIdList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * デバイス情報リスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 * 
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @return DeviceDataの配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getDeviceList(String facilityId) throws FinderException, NamingException {
		
		try {
			SelectFacility select = new SelectFacility();
			ArrayList list = select.getDeviceList(facilityId);
			return list;			
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getDeviceFacilityIdList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ノード詳細取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param attributes
	 * @return 属性名と値のHashMapとして返す
	 * @throws NamingException
	 * @throws FinderException
	 */
	public HashMap getNodeDetail(String facilityId, ArrayList attributes) throws FinderException, NamingException {
		
		try {
			SelectFacility select = new SelectFacility();
			HashMap map = select.getNodeDetail(facilityId, attributes);
			return map;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getNodeDetail() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ノード詳細取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityIdList
	 * @param attributes
	 * @return ファシリティIDと属性値(属性名と値のHashMap)のHashMap
	 * @throws NamingException
	 * @throws FinderException
	 */
	public HashMap getNodeDetail(ArrayList facilityIdList, ArrayList attributes) throws FinderException, NamingException {
		
		try {
			SelectFacility select = new SelectFacility();
			HashMap map = select.getNodeDetail(facilityIdList, attributes);
			return map;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getNodeDetail() -> " + e.getMessage());	
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ノード詳細設定
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param attributes 属性名と値のHashMap
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void setNodeDetail(String facilityId, HashMap attributes) throws FinderException, NamingException {
		ModifyFacility modify = new ModifyFacility();
		modify.setNodeDetail(facilityId, attributes);
	}
	
	/**
	 * スコープ追加
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param property
	 * @throws CreateException
	 * @throws NamingException
	 * @throws RemoveException
	 */
	public void addScope(String parentFacilityId, Property property) throws RemoveException, CreateException, NamingException {
		ModifyFacility modify = new ModifyFacility();
		modify.addScope(parentFacilityId, property);
	}
	
	/**
	 * スコープ変更
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyScope(Property property) throws NamingException, FinderException {
		try {
			ModifyFacility modify = new ModifyFacility();
			modify.modifyScope(property);
		} catch (NamingException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.modifyScope() -> " + e.getMessage());	
			throw e;
		}
	}
	
	/**
	 * ノード追加
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void addNode(Property property) throws NamingException, CreateException {
		Principal pri = m_context.getCallerPrincipal();
			
		ModifyFacility modify = new ModifyFacility();
		modify.addNode(property, pri.getName());
	}
	
	/**
	 * ノード変更
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 * @throws CreateException
	 */
	public void modifyNode(Property property) throws NamingException, FinderException, CreateException {
		try {
			Principal pri = m_context.getCallerPrincipal();
			
			ModifyFacility modify = new ModifyFacility();
			modify.modifyNode(property, pri.getName());
		} catch (NamingException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.modifyNode() -> " + e.getMessage());	
			throw e;
		} catch (CreateException e) {
			throw e;
		}
	}
	
	/**
	 * ノード変更(一括)
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @param parentFacilityId
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyNode(Property property, String parentFacilityId) throws NamingException, FinderException {
		try {
			Principal pri = m_context.getCallerPrincipal();
			
			ModifyFacility modify = new ModifyFacility();
			modify.modifyAllNode(property, parentFacilityId, pri.getName());
		} catch (NamingException e) {
			throw e;
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.modifyNode() -> " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * ノード削除
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws UsedFacilityException 
	 */
	public void deleteNode(String facilityId) throws FinderException, RemoveException, NamingException, UsedFacilityException {
		try {
			DeleteFacility delete = new DeleteFacility();
			delete.deleteNode(facilityId);
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.deleteNode() -> " + e.getMessage());
			throw e;
		} catch (RemoveException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		} catch (UsedFacilityException e) {
			throw e;
		}
	}
	
	/**
	 * スコープ削除
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @throws FinderException
	 * @throws NamingException
	 * @throws RemoveException
	 * @throws UsedFacilityException 
	 */
	public void deleteScope(String facilityId) throws FinderException, NamingException, RemoveException, UsedFacilityException {
		try {
			DeleteFacility delete = new DeleteFacility();
			delete.deleteScope(facilityId);
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.deleteScope() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		} catch (RemoveException e) {
			throw e;
		} catch (UsedFacilityException e) {
			throw e;
		}
	}
	
	/**
	 * スコープへのノードの割り当て
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param facilityIds
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void assignNodeScope(String parentFacilityId, String[] facilityIds) throws NamingException, CreateException {
		try {
			ModifyFacility modify = new ModifyFacility();
			modify.assignNodeScope(parentFacilityId, facilityIds);
		} catch (NamingException e) {
			throw e;
		} catch (CreateException e) {
			throw e;
		}
	}
	
	/**
	 * ノードのスコープからの削除
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param facilityIds
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void releaseNodeScope(String parentFacilityId, String[] facilityIds) throws FinderException, NamingException, RemoveException {
		try {
			DeleteFacility delete = new DeleteFacility();
			delete.releaseNodeScope(parentFacilityId, facilityIds);
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.releaseNodeScope() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		} catch (RemoveException e) {
			throw e;
		}
	}
	
	/**
	 * スコープ用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param mode
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getScopeProperty(String facilityId, int mode, Locale locale) throws FinderException, NamingException {
		try {
			ScopeProperty scope = new ScopeProperty();
			return scope.getProperty(facilityId, mode, locale);
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getScopeProperty() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ノード用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param mode
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getNodeProperty(String facilityId, int mode, Locale locale) throws FinderException, NamingException {
		try {
			NodeProperty node = new NodeProperty();
			return node.getProperty(facilityId, mode, locale);
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getScopeProperty() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ノード用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param locale
	 * @return
	 */
	public Property getNodeFilterProperty(Locale locale) {
		NodeFilterProperty node = new NodeFilterProperty();
		return node.getProperty(locale);
	}
	
	/**
	 * ファシリティパス取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
     *     
     * @ejb.transaction
	 *     type="NotSupported"
	 *     
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param parentFacilityId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public String getFacilityPath(String facilityId, String parentFacilityId) throws FinderException, NamingException {
		try {
			SelectFacility select = new SelectFacility();
			return select.getFacilityPath(facilityId, parentFacilityId);
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getFacilityPath() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 * 
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param hostName
	 * @param ipAddress
	 * @return ファシリティIDの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFacilityIdList(String hostName, String ipAddress) throws FinderException, NamingException {
		try {
			SelectFacility select = new SelectFacility();
			return select.getFacilityIdList(hostName, ipAddress);
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.getFacilityIdList() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
    /**
     * ノードチェック
     * 
     * ファシリティIDがノードかチェックし、結果をbooleanで返す
     * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param parentFacilityId
	 * @return ファシリティIDの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public boolean isNode(String facilityId) throws FinderException, NamingException {
		try {
			SelectFacility select = new SelectFacility();
			return select.isNode(facilityId);
		} catch (FinderException e) {
			m_log.debug("RepositoryControllerBean.isNode() -> " + e.getMessage());
			throw e;
		} catch (NamingException e) {
			throw e;
		}
	}
	
	/**
	 * セパレータ文字列を取得
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @return
	 */
	public String getSeparator() {
		return SelectFacility.SEPARATOR;
	}
}
