/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.repository.ejb.entity.DeviceInfoLocal;
import com.clustercontrol.repository.ejb.entity.FacilityLocal;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ノード用プロパティ作成クラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeProperty {
	/** ファシリティID */
	public static final String FACILITY_ID = "facilityId";
	/** ファシリティ名 */
	public static final String FACILITY_NAME = "facilityName";
	/** 注釈 */
	public static final String DESCRIPTION = "description";
//	/** PING監視 */
//	public static final String PING_MONITOR = "pingMonitoring";
//	/** PING監視ステータス */
//	public static final String PING_MONITOR_STATUS = "pingMonitoringStatus";
//	/** エージェント監視 */
//	public static final String AGENT_MONITOR = "agentMonitoring";
//	/** エージェント監視ステータス */
//	public static final String AGENT_MONITOR_STATUS = "agentMonitoringStatus";
//	/** ステータス監視 */
//	public static final String STATUS_MONITOR = "statusMonitoring";
//	/** イベント監視 */
//	public static final String EVENT_MONITOR = "eventMonitoring";
//	/** エージェント制御 */
//	public static final String AGENT_CONTROL = "agentControl";
	/** DHCPクライアント */
	public static final String DHCP_CLIENT = "dhcpClient";
	/** IPアドレス種別 */
	public static final String IP_ADDRESS_TYPE = "ipAddressType";
	/** IPアドレスのバージョン */
	public static final String IP_ADDRESS_VERSION = "ipAddressVersion";
	/** IPv4のアドレス */
	public static final String IP_ADDRESS_V4 = "ipAddressV4";
	/** IPv6のアドレス */
	public static final String IP_ADDRESS_V6 = "ipAddressV6";
	/** ホスト名 */
	public static final String HOST_NAME = "hostName";
	/** H/Wタイプ */
	public static final String HARDWARE_TYPE = "hardwareType";
	/** プラットフォームファミリ名 */
	public static final String PLATFORM_FAMILY_NAME = "platformFamilyName";
	/** OS名 */
	public static final String OS_NAME = "osName";
	/** ノード名 */
	public static final String NODE_NAME = "nodeName";
	/** OSリリース */
	public static final String OS_RELEASE = "osRelease";
	/** OSバージョン */
	public static final String OS_VERSION = "osVersion";
	/** 文字セット */
	public static final String CHARACTER_SET = "characterSet";
	/** 管理者 */
	public static final String ADMINISTRATOR = "administrator";
	/** 連絡先 */
	public static final String CONTACT = "contact";
	/** 作成日時 */
	public static final String CREATE_TIME = "createTimestamp";
	/** 作成者 */
	public static final String CREATOR_NAME = "creatorName";
	/** 更新者 */
	public static final String MODIFIER_NAME = "ModifierName";
	/** 更新日時 */
	public static final String MODIFY_TIME = "ModifyTime";
	
	/** デバイス名 */
	public static final String DEVICE_NAME = "deviceName";
	/** デバイスOID */
	public static final String DEVICE_OID = "deviceOID";
	/** デバイスインデックス */
	public static final String DEVICE_INDEX = "deviceIndex";
	/** デバイス種別 */
	public static final String DEVICE_TYPE = "deviceType";
	/** デバイス説明 */
	public static final String DEVICE_DESCRIPTION = "deviceDescription";
	
	/** ネットワーク */
	public static final String NETWORK = "network";
	/** OS */
	public static final String OS = "os";	
	/** 保守 */
	public static final String MAINTENANCE = "maintenance";	
	/** デバイス */
	public static final String DEVICE = "device";	
	
	/**
	 * ノード用プロパティを返します。
	 * 
	 * @param facilityId
	 * @param mode
	 * @param locale
	 * @return ノード用プロパティ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getProperty(String facilityId, int mode, Locale locale) throws FinderException, NamingException {
		Property property = getProperty(mode, locale);
		
		if(facilityId != null && facilityId.compareTo("") != 0){
		    //Facility取得
			SelectFacility select = new SelectFacility();
			FacilityLocal facility = select.getFacility(facilityId);
			
			if(facility != null){
				//ファシリティID
				ArrayList propertyList = PropertyUtil.getProperty(property, FACILITY_ID);
				((Property)propertyList.get(0)).setValue(facility.getFacilityId());
				//ファシリティ名
				propertyList = PropertyUtil.getProperty(property, FACILITY_NAME);
				((Property)propertyList.get(0)).setValue(facility.getCn());
				//説明
				propertyList = PropertyUtil.getProperty(property, DESCRIPTION);
				if(facility.getDescription() != null && facility.getDescription().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getDescription());
				}
//				//エージェント制御
//				propertyList = PropertyUtil.getProperty(property, AGENT_CONTROL);
//				if(facility.getAgentControl() != null){
//					((Property)propertyList.get(0)).setValue(facility.getAgentControl());
//				}
//				//エージェント監視
//				propertyList = PropertyUtil.getProperty(property, AGENT_MONITOR);
//				if(facility.getAgentWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getAgentWatch());
//				}
//				//エージェント監視ステータス
//				propertyList = PropertyUtil.getProperty(property, AGENT_MONITOR_STATUS);
//				if(facility.getAgentWatchStatus() != null){
//					((Property)propertyList.get(0)).setValue(facility.getAgentWatchStatus());
//				}
				//文字セット
				propertyList = PropertyUtil.getProperty(property, CHARACTER_SET);
				if(facility.getCharSet() != null && facility.getCharSet().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getCharSet());
				}
				//登録日時
				propertyList = PropertyUtil.getProperty(property, CREATE_TIME);
				if(facility.getCreateTimestamp() != null){
					((Property)propertyList.get(0)).setValue(facility.getCreateTimestamp());
				}
				//登録者
				propertyList = PropertyUtil.getProperty(property, CREATOR_NAME);
				if(facility.getCreatorsName() != null && facility.getCreatorsName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getCreatorsName());
				}
				//DHCPクライアント
				propertyList = PropertyUtil.getProperty(property, DHCP_CLIENT);
				if(facility.getDhcpClient() != null){
					((Property)propertyList.get(0)).setValue(facility.getDhcpClient());
				}
				//ホスト名
				propertyList = PropertyUtil.getProperty(property, HOST_NAME);
				Property parent = (Property)((Property)propertyList.get(0)).getParent();
				if(facility.getHost() != null){
					int index = PropertyUtil.getPropertyIndex(parent, (Property)propertyList.get(0));
					for(int i = 0; i < facility.getHost().size(); i++){
						if(i == 0){
							((Property)propertyList.get(0)).setValue(facility.getHost().get(i));
						}
						else{
							Property copy = PropertyUtil.copy((Property)propertyList.get(0));
							
							((Property)propertyList.get(0)).setValue(facility.getHost().get(i));
							
							parent.addChildren(copy, index + i);
						}
					}
				}
				//IPアドレスV4
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_V4);
				if(facility.getIpNetworkNumber() != null && facility.getIpNetworkNumber().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getIpNetworkNumber());
				}
				//IPアドレスV6
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_V6);
				if(facility.getIpNetworkNumberV6() != null && facility.getIpNetworkNumberV6().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getIpNetworkNumberV6());
				}
				//IPバージョン
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_VERSION);
				if(facility.getIpProtocolNumber() != null){
					((Property)propertyList.get(0)).setValue(facility.getIpProtocolNumber());
				}
				//IPタイプ
				propertyList = PropertyUtil.getProperty(property, IP_ADDRESS_TYPE);
				if(facility.getIpType() != null){
					((Property)propertyList.get(0)).setValue(facility.getIpType());
				}
//				//エベント監視
//				propertyList = PropertyUtil.getProperty(property, EVENT_MONITOR);
//				if(facility.getLogWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getLogWatch());
//				}
				//H/Wタイプ
				propertyList = PropertyUtil.getProperty(property, HARDWARE_TYPE);
				if(facility.getMachine() != null && facility.getMachine().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getMachine());
				}
				//連絡先
				propertyList = PropertyUtil.getProperty(property, CONTACT);
				if(facility.getManagerContact() != null && facility.getManagerContact().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getManagerContact());
				}
				//管理者
				propertyList = PropertyUtil.getProperty(property, ADMINISTRATOR);
				if(facility.getManagerName() != null && facility.getManagerName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getManagerName());
				}
				//更新者
				propertyList = PropertyUtil.getProperty(property, MODIFIER_NAME);
				if(facility.getModifiersName() != null && facility.getModifiersName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getModifiersName());
				}
				//更新日時
				propertyList = PropertyUtil.getProperty(property, MODIFY_TIME);
				if(facility.getModifyTimestamp() != null){
					((Property)propertyList.get(0)).setValue(facility.getModifyTimestamp());
				}
				//ノード名
				propertyList = PropertyUtil.getProperty(property, NODE_NAME);
				if(facility.getNodeName() != null && facility.getNodeName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getNodeName());
				}
				//OS名
				propertyList = PropertyUtil.getProperty(property, OS_NAME);
				if(facility.getOsName() != null && facility.getOsName().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getOsName());
				}
				//OSリリース
				propertyList = PropertyUtil.getProperty(property, OS_RELEASE);
				if(facility.getOsRelease() != null && facility.getOsRelease().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getOsRelease());
				}
				//OSバージョン
				propertyList = PropertyUtil.getProperty(property, OS_VERSION);
				if(facility.getOsVersion() != null && facility.getOsVersion().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getOsVersion());
				}
//				//PING監視
//				propertyList = PropertyUtil.getProperty(property, PING_MONITOR);
//				if(facility.getPingWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getPingWatch());
//				}
//				//PING監視ステータス
//				propertyList = PropertyUtil.getProperty(property, PING_MONITOR_STATUS);
//				if(facility.getPingWatchStatus() != null){
//					((Property)propertyList.get(0)).setValue(facility.getPingWatchStatus());
//				}
//				if(facility.getPingWatch() != null && !facility.getPingWatch().booleanValue()){
//				    ((Property)propertyList.get(0)).setValue("");
//				}
				//プラットフォーム
				propertyList = PropertyUtil.getProperty(property, PLATFORM_FAMILY_NAME);
				if(facility.getPlatform() != null && facility.getPlatform().compareTo("") != 0){
					((Property)propertyList.get(0)).setValue(facility.getPlatform());
				}
//				//ステータス監視
//				propertyList = PropertyUtil.getProperty(property, STATUS_MONITOR);
//				if(facility.getStatusWatch() != null){
//					((Property)propertyList.get(0)).setValue(facility.getStatusWatch());
//				}
				
				//デバイス
				propertyList = PropertyUtil.getProperty(property, DEVICE);
				Property deviceProperty = (Property)propertyList.get(0);
				int index = PropertyUtil.getPropertyIndex(property, deviceProperty);
				
				//デバイスを取得
				Collection deviceList = null;
				try {
					deviceList = facility.getDeviceInfo();
				} catch (FinderException e) {
				}
				if(deviceList != null){
					Iterator itr = deviceList.iterator();
					int i = 0;
					while(itr.hasNext()){
						DeviceInfoLocal d = (DeviceInfoLocal)itr.next();
						if(i == 0){
						    //デバイス名
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_NAME);
							if(d.getCn() != null && d.getCn().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getCn());
							}
							//デバイスOID
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_OID);
							if(d.getSnmpOID() != null && d.getSnmpOID().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getSnmpOID());
							}
							//デバイスINDEX
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_INDEX);
							if(d.getDeviceIndex() != null){
								((Property)propertyList.get(0)).setValue(d.getDeviceIndex());
							}
							//デバイス種別
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_TYPE);
							if(d.getDeviceType() != null && d.getDeviceType().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDeviceType());
							}
							//説明
							propertyList = PropertyUtil.getProperty(deviceProperty, DEVICE_DESCRIPTION);
							if(d.getDescription() != null && d.getDescription().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDescription());
							}
						}
						else{
							Property copy = PropertyUtil.copy(deviceProperty);
							//デバイス名
							propertyList = PropertyUtil.getProperty(copy, DEVICE_NAME);
							if(d.getCn() != null && d.getCn().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getCn());
							}
							//デバイスOID
							propertyList = PropertyUtil.getProperty(copy, DEVICE_OID);
							if(d.getSnmpOID() != null && d.getSnmpOID().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getSnmpOID());
							}
							//デバイスINDEX
							propertyList = PropertyUtil.getProperty(copy, DEVICE_INDEX);
							if(d.getDeviceIndex() != null){
								((Property)propertyList.get(0)).setValue(d.getDeviceIndex());
							}
							//デバイス種別
							propertyList = PropertyUtil.getProperty(copy, DEVICE_TYPE);
							if(d.getDeviceType() != null && d.getDeviceType().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDeviceType());
							}
							//説明
							propertyList = PropertyUtil.getProperty(copy, DEVICE_DESCRIPTION);
							if(d.getDescription() != null && d.getDescription().compareTo("") != 0){
								((Property)propertyList.get(0)).setValue(d.getDescription());
							}
							property.addChildren(copy, index + i);
						}
						i++;
					}
				}
			}
		}
		
		return property;
	}
	
	/**
	 * ノード用プロパティを返します。
	 * 
	 * @param mode
	 * @return ノード用プロパティ
	 */
	public Property getProperty(int mode, Locale locale) {
	    //ファシリティID
		Property facilityId =
			new Property(FACILITY_ID, Messages.getString("facility.id", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		//ファシリティ名
		Property facilityName =
			new Property(FACILITY_NAME, Messages.getString("facility.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		//説明
		Property description =
			new Property(DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
//		//PING監視
//		Property pingMonitoring =
//			new Property(PING_MONITOR, Messages.getString("ping.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//PING監視ステータス
//		Property pingMonitoringStatus =
//			new Property(PING_MONITOR_STATUS, Messages.getString("ping.monitor", local) + Messages.getString("status", local), PropertyConstant.EDITOR_PING_STATUS);
//		//エージェント監視
//		Property agentMonitoring =
//			new Property(AGENT_MONITOR, Messages.getString("agent.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//エージェント監視ステータス
//		Property agentMonitoringStatus =
//			new Property(AGENT_MONITOR_STATUS, Messages.getString("agent.monitor", local) + Messages.getString("status", local), PropertyConstant.EDITOR_BOOL);
//		//ステータス監視
//		Property statusMonitoring =
//			new Property(STATUS_MONITOR, Messages.getString("status.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//イベント監視
//		Property eventMonitoring =
//			new Property(EVENT_MONITOR, Messages.getString("event.monitor", local), PropertyConstant.EDITOR_BOOL);
//		//エージェント制御
//		Property agentControl =
//			new Property(AGENT_CONTROL, Messages.getString("agent.control", local), PropertyConstant.EDITOR_BOOL);
		//DHCPクライアント
		Property dhcpClient =
			new Property(DHCP_CLIENT, Messages.getString("dhcp.client", locale), PropertyConstant.EDITOR_BOOL);
		//IPタイプ
		Property ipAddressType =
			new Property(IP_ADDRESS_TYPE, Messages.getString("ip.address.type", locale), PropertyConstant.EDITOR_NUM, DataRangeConstant.SMALLINT_HIGH, 0);
		//IPバージョン
		Property ipAddressVersion =
			new Property(IP_ADDRESS_VERSION, Messages.getString("ip.address.version", locale), PropertyConstant.EDITOR_NUM, DataRangeConstant.SMALLINT_HIGH, 0);
		//IPアドレスV4
		Property ipAddressV4 =
			new Property(IP_ADDRESS_V4, Messages.getString("ip.address.v4", locale), PropertyConstant.EDITOR_IPV4);
		//IPアドレスV6
		Property ipAddressV6 =
			new Property(IP_ADDRESS_V6, Messages.getString("ip.address.v6", locale), PropertyConstant.EDITOR_IPV6);
		//ホスト名
		Property hostName =
			new Property(HOST_NAME, Messages.getString("host.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//H/Wタイプ
		Property hardwareType =
			new Property(HARDWARE_TYPE, Messages.getString("hardware.type", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//プラットフォーム
		Property platformFamilyName =
			new Property(PLATFORM_FAMILY_NAME, Messages.getString("platform.family.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OS名
		Property osName =
			new Property(OS_NAME, Messages.getString("os.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//ノード名
		Property nodeName =
			new Property(NODE_NAME, Messages.getString("node.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OSリリース
		Property osRelease =
			new Property(OS_RELEASE, Messages.getString("os.release", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OSバージョン
		Property osVersion =
			new Property(OS_VERSION, Messages.getString("os.version", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//文字セット
		Property characterSet =
			new Property(CHARACTER_SET, Messages.getString("character.set", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//管理者
		Property administrator =
			new Property(ADMINISTRATOR, Messages.getString("administrator", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//連絡先
		Property contact =
			new Property(CONTACT, Messages.getString("contact", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//登録者
		Property createTime =
			new Property(CREATE_TIME, Messages.getString("create.time", locale), PropertyConstant.EDITOR_DATETIME);
		//登録日時
		Property creatorName =
			new Property(CREATOR_NAME, Messages.getString("creator.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//更新者
		Property modifyTime =
			new Property(MODIFY_TIME, Messages.getString("update.time", locale), PropertyConstant.EDITOR_DATETIME);
		//更新日時
		Property modifierName =
			new Property(MODIFIER_NAME, Messages.getString("modifier.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);

		//デバイス
		Property deviceName =
			new Property(DEVICE_NAME, Messages.getString("device.name", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイスOID
		Property deviceOID =
			new Property(DEVICE_OID, Messages.getString("device.oid", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイスINDEX
		Property deviceIndex =
			new Property(DEVICE_INDEX, Messages.getString("device.index", locale), PropertyConstant.EDITOR_NUM, DataRangeConstant.SMALLINT_HIGH, 0);
		//デバイス種別
		Property deviceType =
			new Property(DEVICE_TYPE, Messages.getString("device.type", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//説明
		Property deviceDescription =
			new Property(DEVICE_DESCRIPTION, Messages.getString("description", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		//ネットワーク
		Property network = 
			new Property(NETWORK, Messages.getString("network", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//OS
		Property os = 
			new Property(OS, Messages.getString("os", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//保守
		Property maintenance =
			new Property(MAINTENANCE, Messages.getString("maintenance", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		//デバイス
		Property device =
			new Property(DEVICE, Messages.getString("device", locale), PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_1024);
		
		
		//値を初期化
		facilityId.setValue("");
		facilityName.setValue("");
		description.setValue("");
//		pingMonitoring.setValue(new Boolean(false));
//		pingMonitoringStatus.setValue("");
//		agentMonitoring.setValue(new Boolean(false));
//		agentMonitoringStatus.setValue(new Boolean(false));
//		statusMonitoring.setValue(new Boolean(false));
//		eventMonitoring.setValue(new Boolean(false));
//		agentControl.setValue(new Boolean(false));
		dhcpClient.setValue(new Boolean(false));
		ipAddressType.setValue("");
		ipAddressVersion.setValue("");
		ipAddressV4.setValue("");
		ipAddressV6.setValue("");
		hostName.setValue("");
		hardwareType.setValue("");
		platformFamilyName.setValue("");
		osName.setValue("");
		nodeName.setValue("");
		osRelease.setValue("");
		osVersion.setValue("");
		characterSet.setValue("");
		administrator.setValue("");
		contact.setValue("");
		createTime.setValue("");
		creatorName.setValue("");
		modifyTime.setValue("");
		modifierName.setValue("");
		
		deviceName.setValue("");
		deviceOID.setValue("");
		deviceIndex.setValue("");
		deviceType.setValue("");
		deviceDescription.setValue("");

		os.setValue("");
		network.setValue("");
		maintenance.setValue("");
		device.setValue("");

		//モードにより、変更可及びコピー可を設定
		if(mode == PropertyConstant.MODE_ADD){
			facilityId.setModify(PropertyConstant.MODIFY_OK);
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
//			pingMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoringStatus.setModify(PropertyConstant.MODIFY_OK);
//			statusMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			eventMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentControl.setModify(PropertyConstant.MODIFY_OK);
			dhcpClient.setModify(PropertyConstant.MODIFY_OK);
			ipAddressType.setModify(PropertyConstant.MODIFY_OK);
			ipAddressVersion.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV4.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV6.setModify(PropertyConstant.MODIFY_OK);
			hostName.setModify(PropertyConstant.MODIFY_OK);
			hardwareType.setModify(PropertyConstant.MODIFY_OK);
			platformFamilyName.setModify(PropertyConstant.MODIFY_OK);
			osName.setModify(PropertyConstant.MODIFY_OK);
			nodeName.setModify(PropertyConstant.MODIFY_OK);
			osRelease.setModify(PropertyConstant.MODIFY_OK);
			osVersion.setModify(PropertyConstant.MODIFY_OK);
			characterSet.setModify(PropertyConstant.MODIFY_OK);
			administrator.setModify(PropertyConstant.MODIFY_OK);
			contact.setModify(PropertyConstant.MODIFY_OK);
			
			deviceName.setModify(PropertyConstant.MODIFY_OK);
			deviceOID.setModify(PropertyConstant.MODIFY_OK);
			deviceIndex.setModify(PropertyConstant.MODIFY_OK);
			deviceType.setModify(PropertyConstant.MODIFY_OK);
			deviceDescription.setModify(PropertyConstant.MODIFY_OK);
			
			hostName.setCopy(PropertyConstant.COPY_OK);
			device.setCopy(PropertyConstant.COPY_OK);
		}
		else if(mode == PropertyConstant.MODE_MODIFY){
			facilityName.setModify(PropertyConstant.MODIFY_OK);
			description.setModify(PropertyConstant.MODIFY_OK);
//			pingMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentMonitoringStatus.setModify(PropertyConstant.MODIFY_OK);
//			statusMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			eventMonitoring.setModify(PropertyConstant.MODIFY_OK);
//			agentControl.setModify(PropertyConstant.MODIFY_OK);
			dhcpClient.setModify(PropertyConstant.MODIFY_OK);
			ipAddressType.setModify(PropertyConstant.MODIFY_OK);
			ipAddressVersion.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV4.setModify(PropertyConstant.MODIFY_OK);
			ipAddressV6.setModify(PropertyConstant.MODIFY_OK);
			hostName.setModify(PropertyConstant.MODIFY_OK);
			hardwareType.setModify(PropertyConstant.MODIFY_OK);
			platformFamilyName.setModify(PropertyConstant.MODIFY_OK);
			osName.setModify(PropertyConstant.MODIFY_OK);
			nodeName.setModify(PropertyConstant.MODIFY_OK);
			osRelease.setModify(PropertyConstant.MODIFY_OK);
			osVersion.setModify(PropertyConstant.MODIFY_OK);
			characterSet.setModify(PropertyConstant.MODIFY_OK);
			administrator.setModify(PropertyConstant.MODIFY_OK);
			contact.setModify(PropertyConstant.MODIFY_OK);
			
			deviceName.setModify(PropertyConstant.MODIFY_OK);
			deviceOID.setModify(PropertyConstant.MODIFY_OK);
			deviceIndex.setModify(PropertyConstant.MODIFY_OK);
			deviceType.setModify(PropertyConstant.MODIFY_OK);
			deviceDescription.setModify(PropertyConstant.MODIFY_OK);
			
			hostName.setCopy(PropertyConstant.COPY_OK);
			device.setCopy(PropertyConstant.COPY_OK);
		}
		
		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(facilityId);
		property.addChildren(facilityName);
		property.addChildren(description);
		property.addChildren(network);
		property.addChildren(os);
		property.addChildren(maintenance);
		property.addChildren(device);
		property.addChildren(createTime);
		property.addChildren(creatorName);
		property.addChildren(modifyTime);
		property.addChildren(modifierName);
		
		// ネットワークツリー
		network.removeChildren();
//		network.addChildren(pingMonitoring);
//		network.addChildren(pingMonitoringStatus);
//		network.addChildren(agentMonitoring);
//		network.addChildren(agentMonitoringStatus);
//		network.addChildren(agentControl);
//		network.addChildren(statusMonitoring);
//		network.addChildren(eventMonitoring);
		network.addChildren(dhcpClient);
		network.addChildren(ipAddressType);
		network.addChildren(ipAddressVersion);
		network.addChildren(ipAddressV4);
		network.addChildren(ipAddressV6);
		network.addChildren(hostName);

		// OSツリー
		os.removeChildren();
		os.addChildren(nodeName);
		os.addChildren(osName);
		os.addChildren(osRelease);
		os.addChildren(osVersion);
		os.addChildren(platformFamilyName);
		os.addChildren(hardwareType);
		os.addChildren(characterSet);
		
		// 保守ツリー
		maintenance.removeChildren();
		maintenance.addChildren(administrator);
		maintenance.addChildren(contact);
		
		// デバイスツリー
		device.removeChildren();
		device.addChildren(deviceName);
		device.addChildren(deviceOID);
		device.addChildren(deviceIndex);
		device.addChildren(deviceType);
		device.addChildren(deviceDescription);
		
		return property;
	}
}
