/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.util;

import java.text.Collator;
import java.util.Arrays;
import java.util.List;

/**
 * Listソートクラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ListSorter {
	
	/**
	 * ソート
	 * 
	 * @param list
	 */
	@SuppressWarnings("unchecked")
	public void sort(List list) {
		Object[] objectArray = list.toArray();
	    Arrays.sort(objectArray, new DataComparator());
	    
	    list.clear();
	    for(int i = 0; i < objectArray.length; i++)
	    	list.add(objectArray[i]);
	}

	/**
	 * データ比較クラス
	 */
	class DataComparator implements java.util.Comparator{
		protected Collator collator;
		
		/**
		 * コンストラクタ
		 */
		public DataComparator(){
			collator = Collator.getInstance();
		}
		
		/**
		 * 比較
		 * 
		 * @param o1
		 * @param o2
		 * @return
		 */
		public int compare(Object o1, Object o2){
			return collator.compare(o1.toString(), o2.toString());
		}
	}
}

