/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmp.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;
import com.clustercontrol.snmp.bean.MonitorSnmpInfo;
import com.clustercontrol.snmp.ejb.session.MonitorSnmpRunManagementHome;
import com.clustercontrol.snmp.util.ControlSnmpInfo;

/**
 * SNMP監視 数値監視用登録クラス
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class AddMonitorSnmp extends AddMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorSnmp.class );
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	public boolean addCheckInfo() throws CreateException, NamingException{
		
		// SNMP監視情報を追加
		ControlSnmpInfo snmp = new ControlSnmpInfo(m_monitorInfo.getMonitorId(), m_monitorInfo.getMonitorTypeId());
		return snmp.add((MonitorSnmpInfo)m_monitorInfo.getCheckInfo());
	}

	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getJndiName()
	 */
	@Override
	public String getJndiName() {
		return MonitorSnmpRunManagementHome.JNDI_NAME;
	}
}
