-- 
-- TABLE: cc_snmp_trap_mib_mst 
--

CREATE TABLE cc_snmp_trap_mib_mst(
    mib           VARCHAR(64)     NOT NULL,
    order_no      SMALLINT,
    description   VARCHAR(256),    
    reg_date      TIMESTAMP,
    update_date   TIMESTAMP,
    reg_user      VARCHAR(64),
    update_user   VARCHAR(64),
    CONSTRAINT p_key_cc_snmp_trap_mib_mst PRIMARY KEY (mib)
) 
;

-- 
-- TABLE: cc_snmp_trap_mst
--

CREATE TABLE cc_snmp_trap_mst(
    mib           VARCHAR(64)     NOT NULL,
    trap_oid      VARCHAR(64)     NOT NULL,
    generic_id    SMALLINT        NOT NULL,
    specific_id   INT             NOT NULL,
    uei           VARCHAR(256),
    priority      SMALLINT,
    logmsg        VARCHAR(256),
    descr         TEXT,
    CONSTRAINT p_key_cc_snmp_trap_mst PRIMARY KEY (mib, trap_oid, generic_id, specific_id)
) 
;

-- 
-- TABLE: cc_snmp_trap_info 
--

CREATE TABLE cc_snmp_trap_info(
    monitor_id        VARCHAR(64)     NOT NULL,
    description       VARCHAR(256),
    facility_id       VARCHAR(64),
    community_name    VARCHAR(64),
    notify_id         VARCHAR(64),
    application       VARCHAR(64),
    valid_flg         SMALLINT        NOT NULL,
    calendar_id       VARCHAR(64),
    reg_date          TIMESTAMP,
    update_date       TIMESTAMP,
    reg_user          VARCHAR(64),
    update_user       VARCHAR(64),
    CONSTRAINT p_key_cc_snmp_trap_info PRIMARY KEY (monitor_id)
) 
;

-- 
-- TABLE: cc_snmp_trap_oid_info
--

CREATE TABLE cc_snmp_trap_oid_info(
    monitor_id    VARCHAR(64)     NOT NULL,
    mib           VARCHAR(64)     NOT NULL,
    trap_oid      VARCHAR(64)     NOT NULL,
    generic_id    SMALLINT        NOT NULL,
    specific_id   INT             NOT NULL,
    valid_flg     SMALLINT,
    priority      SMALLINT,    
    logmsg        VARCHAR(256),
    descr         TEXT,
    CONSTRAINT p_key_cc_snmp_trap_oid_info PRIMARY KEY (monitor_id, mib, trap_oid, generic_id, specific_id)
) 
;


-- 
-- TABLE: cc_snmp_trap_mst 
--

ALTER TABLE cc_snmp_trap_mst ADD CONSTRAINT Refcc_snmp_trap_mib_mst1
    FOREIGN KEY (mib)
    REFERENCES cc_snmp_trap_mib_mst(mib)
;

-- 
-- TABLE: cc_snmp_trap_info 
--

ALTER TABLE cc_snmp_trap_info ADD CONSTRAINT Refcc_notify_info4
    FOREIGN KEY (notify_id)
    REFERENCES cc_notify_info(notify_id)
;

-- 
-- TABLE: cc_snmp_trap_oid_info 
--

ALTER TABLE cc_snmp_trap_oid_info ADD CONSTRAINT Refcc_snmp_trap_info1
    FOREIGN KEY (monitor_id)
    REFERENCES cc_snmp_trap_info(monitor_id)
;

ALTER TABLE cc_snmp_trap_oid_info ADD CONSTRAINT Refcc_snmp_trap_mst1
    FOREIGN KEY (mib, trap_oid, generic_id, specific_id)
    REFERENCES cc_snmp_trap_mst(mib, trap_oid, generic_id, specific_id)
;
