/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.util;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * JDBCドライバリソース取得クラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class JdbcDriverUtil {
    private static final String RESOURCE_BUNDLE = "com.clustercontrol.sql.util.jdbc";

    private static ResourceBundle m_bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);

    private static final String JDBC_DRIVER = "jdbc.driver";
    private static final String JDBC_DRIVER_NAME = "jdbc.driver.name.";
    private static final String JDBC_DRIVER_CLASSNAME = "jdbc.driver.classname.";
    
    private JdbcDriverUtil() {

    }

    /**
     * JDBCドライバ名、クラス名を取得
     * 
     * @return
     */
    public static List<List> getJdbcDriver() {
    	List<List> list = new ArrayList<List>();
    	
    	//JDBCドライバ数取得
    	Integer count = Integer.valueOf(getString(JDBC_DRIVER, "0"));
    	
    	for(int i = 1; i <= count.intValue(); i++){
    		List<String> driver = new ArrayList<String>();
    		driver.add(getString(JDBC_DRIVER_NAME + i, ""));
    		driver.add(getString(JDBC_DRIVER_CLASSNAME + i, ""));
    		list.add(driver);
    	}
    	return list;
    }
    
    /**
     * Returns the resource object with the given key in the resource bundle. If
     * there isn't any value under the given key, the default value is returned.
     * 
     * @param key
     *            the resource name
     * @param def
     *            the default value
     * @return the string
     */
    public static String getString(String key, String def) {
        try {
            return m_bundle.getString(key);
        } catch (MissingResourceException e) {
            return def;
        }
    }
}