/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.syslogng.forward;

import java.util.Date;

/**
 * syslogメッセージ情報を保持するクラスです。<BR>
 * メッセージのホスト名、発生日時、メッセージを格納します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class MessageInfo {
	
	/** ホスト名。 */
	private String m_hostName;
	
	/** 発生日時。 */
	private Date m_generationDate;
	
	/** メッセージ。 */
	private String m_message;
	
	
	/**
	 * 発生日時を返します。
	 * 
	 * @return 発生日時
	 */
	public Date getGenerationDate() {
		return m_generationDate;
	}
	
	/**
	 * 発生日時を設定します。
	 * 
	 * @param generationDate 発生日時
	 */
	public void setGenerationDate(Date generationDate) {
		m_generationDate = generationDate;
	}
	
	/**
	 * ホスト名を返します。
	 * 
	 * @return ホスト名
	 */
	public String getHostName() {
		return m_hostName;
	}
	
	/**
	 * ホスト名を設定します。
	 * 
	 * @param hostName ホスト名
	 */
	public void setHostName(String hostName) {
		m_hostName = hostName;
	}
	
	/**
	 * メッセージを返します。
	 * 
	 * @return メッセージ
	 */
	public String getMessage() {
		return m_message;
	}
	
	/**
	 * メッセージを設定します。
	 * 
	 * @param message メッセージ
	 */
	public void setMessage(String message) {
		m_message = message;
	}
}
