/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.util;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.syslogng.ejb.session.SyslogNGController;
import com.clustercontrol.syslogng.ejb.session.SyslogNGControllerHome;
import com.clustercontrol.util.LoginManager;

/**
 * EJBとのコネクションを管理するクラスです。<BR>
 * シングルトン。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class EjbConnectionManager {
    public static final String KEY_EJB_URL = "ejbUrl";
    public static final String VALUE_EJB_URL = "jnp://localhost:1099";
    
    /** シングルトン用インスタンス。 */
    private static EjbConnectionManager m_instance = null;
    /** コンテキスト。 */
    private NamingContext m_ctx = null;

    /**
	 * 本クラスのインスタンスを返します。<BR>
	 * 
	 * シングルトン用インスタンスが<code> null </code>ならば、インスタンスを生成します。<BR>
	 * シングルトン用インスタンスが存在すれば、シングルトン用インスタンスを返します。
	 * 
	 * @return 唯一のインスタンス
	 */
    public static EjbConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new EjbConnectionManager();
        }
        return m_instance;
    }

    private EjbConnectionManager() {

    }

    /**
     * syslog-ng監視 SessionBean のインスタンスを返します。<BR>
	 * 
	 * ログインマネージャにてコンテキストを取得し、
	 * syslog-ng監視 SessionBean のインスタンスを取得します。
	 * 
	 * @return syslog-ng監視 SessionBean
	 * @see com.clustercontrol.util.LoginManager
	 * @see com.clustercontrol.syslogng.ejb.session.SyslogNGController
	 * @see com.clustercontrol.syslogng.ejb.session.SyslogNGControllerHome
     */
    public synchronized SyslogNGController getSyslogNGController() {
        try {
            m_ctx = LoginManager.getContextManager().getNamingContext();
        } catch (NamingException e) {
            return null;
        }

        SyslogNGControllerHome home;
        try {
            home = (SyslogNGControllerHome) m_ctx
                    .lookup(SyslogNGControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
}