/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.syslogng.ejb.entity;

import java.sql.Timestamp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * フィルタ情報のCMP Entity Beanです。
 *
 * @ejb.bean name="SyslogMonitorRule"
 *	jndi-name="SyslogMonitorRule"
 *	type="CMP"
 *  primkey-field="orderNo" 
 *  schema="SyslogMonitorRule" 
 *  cmp-version="2.x"
 *  data-source="java:/HinemosDS"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 *  @ejb.persistence 
 *   table-name="cc_syslog_monitor_rule" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM SyslogMonitorRule as a"  
 *    signature="java.util.Collection findAll()"
 * 
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAllByOrderNoOrder()"
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM SyslogMonitorRule as a ORDER BY a.orderNo"
 *    signature="java.util.Collection findAllByOrderNoOrder()"  
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM SyslogMonitorRule as a WHERE a.facilityId = ?1"  
 *    signature="java.util.Collection findByFacilityId(java.lang.String facilityId)"  
 *
 * @ejb.pk class="java.lang.Integer"
 **/
public abstract class SyslogMonitorRuleBean implements javax.ejb.EntityBean {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( SyslogMonitorRuleBean.class );
	
	/**
	 * フィルタ情報を生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param orderNo 順序
	 * @param description 説明
	 * @param facilityId ファシリティID
	 * @param pattern パターンマッチ表現
	 * @param processType 処理タイプ
	 * @param priority 重要度
	 * @param monitorId 監視項目ID
	 * @param application アプリケーション
	 * @param messageId メッセージID
	 * @param message メッセージ
	 * @param notifyId 通知ID
	 * @param calendarId カレンダID 
	 * @param jobRun ジョブ実行
	 * @param jobId ジョブ実行のジョブID
	 * @param jobInhibitionFlg ジョブ実行の通知抑制と連動
	 * @param jobFailurePriority ジョブ実行の呼出失敗時の重要度
	 * @param validFlg 有効フラグ
	 * @param regDate 作成日時
	 * @param updateDate 最終変更日時
	 * @param regUser 新規作成ユーザ
	 * @param updateUser 最終変更ユーザ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
     * @see com.clustercontrol.bean.PriorityConstant
     * @see com.clustercontrol.bean.YesNoConstant
     * @see com.clustercontrol.bean.ValidConstant
	 */
	public java.lang.Integer ejbCreate(
			Integer orderNo,
			String description,
			String facilityId,
			String pattern,
			Integer processType,
			Integer priority,
			String monitorId,
			String application,
			String messageId,
			String message,
			String notifyId,
			String calendarId,
			Integer jobRun,
			String jobId,
			Integer jobInhibitionFlg,
			Integer jobFailurePriority,
			Integer validFlg,
			Timestamp regDate,
			Timestamp updateDate,
			String regUser, 
			String updateUser) throws javax.ejb.CreateException {
		
		this.setOrderNo(orderNo);
		this.setDescription(description);
		this.setFacilityId(facilityId);
		this.setPattern(pattern);
		this.setProcessType(processType);
		this.setPriority(priority);
		this.setMonitorId(monitorId);
		this.setApplication(application);
		this.setMessageId(messageId);
		this.setMessage(message);
		this.setNotifyId(notifyId);
		this.setCalendarId(calendarId);
		this.setJobRun(jobRun);
		this.setJobId(jobId);
		this.setJobInhibitionFlg(jobInhibitionFlg);
		this.setJobFailurePriority(jobFailurePriority);
		this.setValidFlg(validFlg);
		this.setRegDate(regDate);
		this.setUpdateDate(updateDate);
		this.setRegUser(regUser);
		this.setUpdateUser(updateUser);
		
		return null;
	}
	
	public void ejbPostCreate() throws javax.ejb.CreateException {
	}
	
	/**
	 * 順序を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="order_no"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 順序
	 */
	public abstract java.lang.Integer getOrderNo();
	
	/**
	 * 順序を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param orderNo 順序
	 */
	public abstract void setOrderNo(java.lang.Integer orderNo);
	
	/**
	 * 説明を返します。
	 *
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public abstract java.lang.String getDescription();
	
	/**
	 * 説明を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public abstract void setDescription(java.lang.String description);
	
	/**
	 * ファシリティIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return ファシリティID
	 */
	public abstract java.lang.String getFacilityId();
	
	/**
	 * ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId ファシリティID
	 */
	public abstract void setFacilityId(java.lang.String facilityId);
	
	/**
	 * ジョブ実行の呼出失敗時の重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_failure_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 呼出失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getJobFailurePriority();
	
	/**
	 * ジョブ実行の呼出失敗時の重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobFailurePriority 呼出失敗時の重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setJobFailurePriority(Integer jobFailurePriority);
	
	/**
	 * ジョブ実行のジョブIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public abstract String getJobId();
	
	/**
	 * ジョブ実行のジョブIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobId ジョブID
	 */
	public abstract void setJobId(String jobId);
	
	/**
	 * ジョブ実行の通知抑制と連動を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 通知抑制と連動
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public abstract Integer getJobInhibitionFlg();
	
	/**
	 * ジョブ実行の通知抑制と連動を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobInhibitionFlg 通知抑制と連動
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public abstract void setJobInhibitionFlg(Integer jobInhibitionFlg);
	
	/**
	 * ジョブ実行を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_run"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ジョブ実行
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public abstract Integer getJobRun();
	
	/**
	 * ジョブ実行を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobRun ジョブ実行
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public abstract void setJobRun(Integer jobRun);
	
	/**
	 * パターンマッチ表現を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="pattern"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return パターンマッチ表現
	 */
	public abstract java.lang.String getPattern();
	
	/**
	 * パターンマッチ表現を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param pattern パターンマッチ表現
	 */
	public abstract void setPattern(java.lang.String pattern);
	
	/**
	 * 処理タイプを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="process_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 処理タイプ
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
	 */
	public abstract java.lang.Integer getProcessType();
	
	/**
	 * 処理タイプを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param processType 処理タイプ
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
	 */
	public abstract void setProcessType(java.lang.Integer processType);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 *     
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract java.lang.Integer getPriority();
	
	/**
	 * 重要度を設定します。
	 *  
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(java.lang.Integer priority);
	
	/**
	 * 監視項目IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *     
	 * @ejb.interface-method
	 * 
	 * @return 監視項目ID
	 */
	public abstract java.lang.String getMonitorId();
	
	/**
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 監視項目ID
	 */
	public abstract void setMonitorId(java.lang.String monitorId);
	
	/**
	 * アプリケーションを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="application"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return アプリケーション
	 */
	public abstract java.lang.String getApplication();
	
	/**
	 * アプリケーションを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param application アプリケーション
	 */
	public abstract void setApplication(java.lang.String application);
	
	/**
	 * メッセージIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return メッセージID
	 */
	public abstract java.lang.String getMessageId();
	
	/**
	 * メッセージIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param messageId メッセージID
	 */
	public abstract void setMessageId(java.lang.String messageId);
	
	/**
	 * メッセージを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return メッセージ
	 */
	public abstract java.lang.String getMessage();
	
	/**
	 * メッセージを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param message メッセージ
	 */
	public abstract void setMessage(java.lang.String message);
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *    jdbc-type="VARCHAR"
	 *    sql-type="VARCHAR(64)"
	 *    read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract java.lang.String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(java.lang.String notifyId);
	
	/**
	 * 有効/無効を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="SMALLINT"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 有効/無効
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract java.lang.Integer getValidFlg();
	
	/**
	 * 有効/無効を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param validFlg 有効/無効
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setValidFlg(java.lang.Integer validFlg);
	
	/**
	 * 作成日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return regDate 作成日時
	 */
	public abstract Timestamp getRegDate();
	
	/**
	 * 作成日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regDate 作成日時
	 */
	public abstract void setRegDate(Timestamp regDate);
	
	/**
	 * 新規作成ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public abstract java.lang.String getRegUser();
	   
	/**
	 * 新規作成ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regUser 新規作成ユーザ
	 */
	public abstract void setRegUser(java.lang.String regUser);
	
	/**
	 * 最終変更日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 最終変更日時
	 */
	public abstract Timestamp getUpdateDate();
	
	/**
	 * 最終変更日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateDate 最終変更日時
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	
	/**
	 * 最終変更ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 最終変更ユーザ
	 */
	public abstract java.lang.String getUpdateUser();
	   
	/**
	 * 最終変更ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateUser 最終変更ユーザ
	 */
	public abstract void setUpdateUser(java.lang.String updateUser);
	
	/**
	 * カレンダIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="calendar_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return カレンダID
	 */
	public abstract java.lang.String getCalendarId();
	
	/**
	 * カレンダIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param calendarId カレンダID
	 */
	public abstract void setCalendarId(String calendarId);
	
}
