/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.troubledetection.monitor;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import javax.jms.InvalidSelectorException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.mq.Subscription;
import org.jboss.mq.selectors.Selector;

import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.troubledetection.output.OutputLog;
import com.clustercontrol.troubledetection.util.NotifyMessages;

/**
 * PostgresFprest監視クラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorSyslogForward extends MonitorBase {
	private static Log log = LogFactory.getLog(MonitorSyslogForward.class);
	
	protected static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	protected static final String OBJECT_NAME = "jboss.mq.destination:name=clustercontrol/Repository/update,service=Topic";
	protected static final String OPERATION_NAME = "listAllSubscriptions";
	
	/**
	 * 監視実行
	 * 
	 * @see com.clustercontrol.troubledetection.monitor.MonitorBase#run()
	 */
	public void run() {
		log.debug("run() start :");
		
		boolean syslogForward1 = false;
		boolean syslogForward2 = false;
		
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptorを取得
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectNameを設定
	        ObjectName name = new ObjectName(OBJECT_NAME);
	        
	        //ObjectNameのOperationNameのメソッドを実行
	        Object returnObject = server.invoke(name, OPERATION_NAME, null, null);

	        //結果をチェック
	        if(returnObject instanceof List){
		        //チェック文字列を作成
		        String checkString1 = "MultiId='" + this.troubleDetectionInfo.getSyslogForward1() + "'";
		        String checkString2 = "MultiId='" + this.troubleDetectionInfo.getSyslogForward2() + "'";
		        
	        	for(int i = 0; i < ((List)returnObject).size(); i++){
	        		//Subscription取得
	        		Subscription subscription = (Subscription)((List)returnObject).get(i);
	        		
	        		try {
	        			//SubscriptionからSelectorを取得
	        			Selector selecter = subscription.getSelector();
	        			
	        			//Selectorとチェック文字列を比較
	        			if(selecter != null){
	    				
	        				//プロセス1
			        		if(selecter.selector.indexOf(checkString1) != -1){
			        			//チャック文字列を含む場合
			        			syslogForward1 = true;
			        		}
			        		//プロセス2
			        		else if(selecter.selector.indexOf(checkString2) != -1){
			        			//チャック文字列を含む場合
			        			syslogForward2 = true;
			        		}
	        			}
		        		
					} catch (InvalidSelectorException e) {
						log.debug("run() : " + e.getMessage());
					}
	        	}
	        }
	        
		} catch (NamingException e) {
			log.debug("run() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			log.debug("run() : " + e.getMessage());
		} catch (NullPointerException e) {
			log.debug("run() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			log.debug("run() : " + e.getMessage());
		} catch (MBeanException e) {
			log.debug("run() : " + e.getMessage());
		} catch (ReflectionException e) {
			log.debug("run() : " + e.getMessage());
		} catch (IOException e) {
			log.debug("run() : " + e.getMessage());
		}

		//ログ出力
		logout(syslogForward1, syslogForward2);
		
		log.debug("run() end :");
	}
	
	/**
	 * ログ出力
	 * 
	 * @param syslogForward1
	 * @param syslogForward2
	 */
	protected void logout(boolean syslogForward1, boolean syslogForward2) {
		
		String application = NotifyMessages.getString("syslog.application");
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//プロセス1正常、プロセス2正常
		if(syslogForward1 && syslogForward2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("SYSLOG01");
			//メッセージID
			info.setMessageId("001");
			//メッセージ、オリジナルメッセージ
			info.setMessage(NotifyMessages.getString("syslog01.001.message"));
			String[] args = {this.troubleDetectionInfo.getSyslogForward1(), 
					this.troubleDetectionInfo.getSyslogForward2()};
			info.setMessageOrg(NotifyMessages.getString("syslog01.001.org.message", args));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("syslog01.001.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//プロセス1異常、プロセス2正常
		else if(!syslogForward1 && syslogForward2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("SYSLOG01");
			//メッセージID
			info.setMessageId("002");
			//メッセージ、オリジナルメッセージ
			String[] args1 = {this.troubleDetectionInfo.getSyslogForward1()};
			info.setMessage(NotifyMessages.getString("syslog01.002.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getSyslogForward1(), 
					this.troubleDetectionInfo.getSyslogForward2()};
			info.setMessageOrg(NotifyMessages.getString("syslog01.002.org.message", args2));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("syslog01.002.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//プロセス1正常、プロセス2異常
		else if(syslogForward1 && !syslogForward2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("SYSLOG01");
			//メッセージID
			info.setMessageId("002");
			//メッセージ、オリジナルメッセージ
			String[] args1 = {this.troubleDetectionInfo.getSyslogForward2()};
			info.setMessage(NotifyMessages.getString("syslog01.002.message", args1));
			String[] args2 = {this.troubleDetectionInfo.getSyslogForward2(), 
					this.troubleDetectionInfo.getSyslogForward1()};
			info.setMessageOrg(NotifyMessages.getString("syslog01.002.org.message", args2));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("syslog01.002.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
		//プロセス1異常、プロセス2異常
		else if(!syslogForward1 && !syslogForward2){
			//通知情報作成
			LogOutputInfo info = new LogOutputInfo();
			//プラグインID
			info.setPluginId(PLUGIN_ID);
			//アプリケーション
			info.setApplication(application);
			//監視項目ID
			info.setMonitorId("SYSLOG01");
			//メッセージID
			info.setMessageId("003");
			//メッセージ、オリジナルメッセージ
			info.setMessage(NotifyMessages.getString("syslog01.003.message"));
			String[] args = {this.troubleDetectionInfo.getSyslogForward1(), 
					this.troubleDetectionInfo.getSyslogForward2()};
			info.setMessageOrg(NotifyMessages.getString("syslog01.003.org.message", args));
			//ファシリティID
			info.setFacilityId(FACILITY_ID);
			//スコープ
			info.setScopeText("");
			//重要度
			info.setPriority(getPriority(NotifyMessages.getString("syslog01.003.priority")));
			//発生日時
			info.setGenerationDate(new Date());
			
			//ログ出力
			output.outputLog(notifyInfo, info);
		}
	}
	
	/**
	 * ログ出力
	 * 
	 * @param messageId
	 */
	public void logout(String monitorId, String messageId){
		
		String application = NotifyMessages.getString("syslog.application");
		String key = monitorId.toLowerCase() + "." + messageId;
		
		OutputLog output = new OutputLog(troubleDetectionInfo);
		
		//通知情報作成
		LogOutputInfo info = new LogOutputInfo();
		//プラグインID
		info.setPluginId(PLUGIN_ID);
		//アプリケーション
		info.setApplication(application);
		//監視項目ID
		info.setMonitorId(monitorId);
		//メッセージID
		info.setMessageId(messageId);
		//メッセージ、オリジナルメッセージ
		info.setMessage(NotifyMessages.getString(key + ".message"));
		info.setMessageOrg(NotifyMessages.getString(key + ".org.message"));
		//ファシリティID
		info.setFacilityId(FACILITY_ID);
		//スコープ
		info.setScopeText("");
		//重要度
		info.setPriority(getPriority(NotifyMessages.getString(key + ".priority")));
		//発生日時
		info.setGenerationDate(new Date());
		
		//ログ出力
		output.outputLog(notifyInfo, info);
	}
}
